<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderDetails;
use Illuminate\Http\Request;


class OrderController extends Controller
{
    public function accept_order(Request $request)
    {
        $request->validate([
            'order_id' => 'required|exists:order_details,id',
        ]);
    
        $order         = OrderDetails::find($request->order_id);
        $order->status = 'accepted';
        $order->save();
        return redirect()->route('recent_orders')->with('successmessage', 'Order accepted successfully!');
      
    }
    

    public function decline_order(Request $request)
{
    $request->validate([
        'order_id' => 'required|exists:order_details,id',
    ]);

    $order = OrderDetails::find($request->order_id);
    $order->status = 'cancelled'; 
    $order->save();

    return redirect()->route('recent_orders')->with('successmessage', 'Order declined successfully.');
}
public function ship_order(Request $request)
{
    $request->validate([
        'order_id' => 'required|exists:order_details,id',
        
    ]);

    $order         = OrderDetails::find($request->order_id);
    $order->status = 'shipped';
    $order->save();

    return redirect()->route('accepted_orders')->with('successmessage', 'Order shipped successfully!');
}

public function confirm_delivery(Request $request)
{
    $validated = $request->validate([
        'order_id' => 'required|exists:orders,id',
        'status' => 'required|string|in:delivered',
    ]);

    
    $order         = OrderDetails::find($request->order_id);
    $order->status = 'delivered';
    $order->save();

    return redirect()->route('delivered_orders')->with('successmessage', 'Order has been marked as delivered.');
}


public function cancelledOrders()
{
    $cancelled_orders = OrderDetails::where('status', 'cancelled')->get();
 
    return view('admin.cancelled_order', compact('cancelled_orders'));
}
public function viewCancelOrder($order_random_id)
{
   
    $cancelled_order = Order::with(['products.product.category', 'products.product.subcategory'])
                            ->where('order_random_id', $order_random_id)
                            ->where('status', 'cancelled')
                            ->get();

    return view('admin.view_cancel_order', compact('cancelled_order'));
}
}


