<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AddressResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'house_no'  => $this->house_no,
            'road_name' => $this->road_name,
            'landmark'  => $this->landmark,
            'district'  => $this->district,
            'state'     => $this->state,
            'pin'       => $this->pin,
        ];
    }
}
