<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CatgryByProductResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'             => $this->id,
            'title'          => $this->title,
            'description'    => $this->description,
            'image'          => url($this->image),
            'brand'          => $this->brand,
            'package'        => $this->package,
            'is_wishlist'    => $this->is_wishlist,
            'category_id'    => $this->category ? $this->category->id : null,
            'subcategory_id' => $this->subcategory ? $this->subcategory->id : null,
            'variations'       => ProductVarientResources::collection($this->whenLoaded('variants')),
        ];
       
    }
}
