<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderDetails extends Model
{
    use HasFactory;
    protected $fillable = [
        'order_date',
        'user_id',
        'user_name',
        'category_id',
        'category_name',
        'subcategory_id',
        'subcategory_name',
        'order_random_id',
        'product_details_id',
        'product_details_name',
        'quantity',
        'amount',
        'delivery_address',
        'instruction',
        'courier',
        'tracking_id',
        'status',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_details_id');
    }
}
