<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'subcategory_id',
        'image',
        'brand',
        'title',
        'description',
        'package',
        'is_wishlist'
    ];

    public function variants()
    {
        return $this->hasMany(ProductVarient::class, 'product_id');
    }
   
    public function orders()
    {
        return $this->hasMany(Order::class, 'product_id');
    }

    // Correct relationship for category
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    // Correct relationship for subcategory
    public function subcategory()
    {
        return $this->belongsTo(Category::class, 'subcategory_id');
    }

    public function wishlist()
{
    return $this->hasMany(Wishlist::class, 'product_id','id');
}

// In Product.php


}
