<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('income_wallets', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->float('cash_wallet',7,5)->default(0);
            $table->float('shopping_wallet',7,5)->default(0);
            $table->float('withdraw_wallet',7,5)->default(0);
            $table->float('referral_income',7,5)->default(0);
            $table->float('video_income',7,5)->default(0);
            $table->float('welcome_income',7,5)->default(0);
            $table->boolean('is_active')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('income_wallets');
    }
};
