<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('referral_incomes', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('membership_id');
            $table->float('amount', 15, 2)->default(0);
            $table->string('description');
            $table->boolean('is_active')->default(1);
            $table->string('type');
            $table->string('remark');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_incomes');
    }
};
