@extends('admin.layouts')
@section('title', 'Add Product')

@section('header')
<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{ asset('/assets/css/formILY.css') }}">
@endsection

@section('content')
<div class="container-fluid page-wrapper">
    <div class="row">
        <div class="d-flex align-items-center">
            <h3 class="page-top-heading">Add Product</h3>
        </div>
    </div>

    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-12">
            <div class="card ILY-form-card">
                <div class="card-header d-none">
                    <h5 class="card-title">Add Product</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('store_product') }}" method="POST" enctype="multipart/form-data">
                        @csrf 
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="category_id" class="form-label">Select Category</label>
                                    <select id="category_id" name="category_id" class="form-select" aria-label="Category Select">
                                        <option value="">Select</option>
                                        @foreach($categories as $category)
                                            @if($category->category_type == 1) <!-- Only show main categories -->
                                                <option value="{{ $category->id }}">{{ $category->category_name }}</option>   
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="subcategory_select" class="form-label">Select Sub Category</label>
                                    <select id="subcategory_select" name="subcategory_id" class="form-select" aria-label="Sub Category Select" required>
                                        <option value="">Select</option>
                                    </select>
                                    @error('subcategory_id')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                    
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="image" class="form-label">Choose Image</label>
                                    <input class="form-control" name="image" type="file" id="image">
                                    @error('image')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="brand" class="form-label">Brand</label>
                                    <input type="text" name="brand" class="form-control" id="brand" placeholder="Enter Brand Name">
                                    @error('brand')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" name="title" class="form-control" id="title" placeholder="Enter Product Title">
                                    @error('title')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" class="form-control" id="description" rows="3" placeholder="Write Here"></textarea>
                                    @error('description')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group mb-3">
                                    <label for="package" class="form-label">Package</label>
                                    <input type="text" name="package" class="form-control" id="package" placeholder="Enter Package">
                                    @error('package')
                                        <small class="text-danger">{{ $message }}</small>
                                    @enderror
                                </div>
                            </div>
                            <div class="button-container mt-4">
                                <button type="submit" class="btn btn-primary submit-btn w-100 py-3">
                                    <i class="fa-regular fa-circle-check me-2"></i>Submit
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- jQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
      $(document).ready(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $('#category_id').on('change', function() {
            const categoryId = $(this).val();
            
            if (categoryId) {
                $.ajax({
                    url: 'getSubcategories',
                    type: 'GET',
                    data: { categoryId: categoryId },
                    dataType: 'json',
                    success: function(data) {
                        $('#subcategory_select').html('<option value="">Select</option>');
                        $.each(data.subcategories, function(index, subcategory) {
                            $('#subcategory_select').append(
                                $('<option></option>').val(subcategory.id).text(subcategory.subcategory_name)
                            );
                        });
                    },
                    
                    error: function(xhr, status, error) {
                        console.error('Error fetching subcategories:', error);
                        console.error('Response:', xhr.responseText); 
                    }
                });
            } else {
                $('#subcategory_select').html('<option value="">Select</option>');
            }
        });
    });

</script>


@endsection
