
<?php $__env->startSection('title', 'Notification'); ?>
<?php $__env->startSection('header'); ?>

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/dataTables.bootstrap5.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/responsive.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/datatable/buttons.dataTables.min.css">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('/assets')); ?>/css/formILY.css">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="container-fluid page-wrapper category-container">

   <div class="row">
        <div class="d-flex align-items-center">
            <h3 class="page-top-heading">Daily Task</h3>
        </div>
    </div>

    <div class="row d-flex justify-content-center mt-4">
        <div class="col-lg-6">
            <div class="card ILY-form-card">
                <div class="card-header">
                    <h5 class="card-title">Add Daily Task</h5>
                </div>
                <div class="card-body">
                    
                    <form action="<?php echo e(route('add_video_form')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>  
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group mb-3">
                                    <label for="notification_title" class="form-label">Date</label>
                                    <input type="date" name="date" class="form-control" id="task">
                                    
                                </div>
                                <div class="form-group mb-3">
                                    <label for="notification_title" class="form-label">Task</label>
                                    <input type="text" name="task" class="form-control" id="task">
                                    
                                </div>
                               <div class="form-group mb-3">
                                    <label for="notification_title" class="form-label">Note</label>
                                    <input type="text" name="note" class="form-control" id="notification_title">
                                    
                                </div>
                                <div class="form-group mb-3">
                                    <label for="description" class="form-label">Video Link</label>
                                    <textarea name="video_link" class="form-control" id="description" rows="3"></textarea>
                                    
                                </div>
                                <div class="form-group mb-3">
                                    <label for="time" class="form-label">Time Limit (hh:mm:ss)</label>
                                    <input type="text" name="time" class="form-control" id="time" placeholder="HH:MM:SS">
                                </div>
                                

                                <div class="form-group mb-3">
                                    <label for="banner_img" class="form-label">Choose Cover Image</label>
                                    <input type="file" name="cover_image" class="form-control custom-file-input" id="cover_image">
                                </div>
                                <div class="button-container mt-4">
                                    <button type="submit" class="btn btn-primary submit-btn"><i class="fa-regular fa-circle-check me-2"></i>Submit</button>
                                </div>
                            </div>
                        </div>
                    </form>
                       
                </div>
            </div>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-5">
        <div class="col-lg-12">
           <div class="mb-3">
               <h6 class="table-heading">History</h6>
           </div>
            <div class="card datatable-card">
                <div class="card-body">
                <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>Created_at</th>
                                <th>Video Link</th>
                                <th>Note</th>
                                <th>Time</th>
                                <th>Cover Image</th>
                                <th>Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $datatables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
          
                              <td><?php echo e($loop->iteration); ?></td>
                              <td><?php echo e($data->created_at); ?></td>
                              <td><?php echo e($data->video_link); ?></td>
                              <td><?php echo e($data->note); ?></td>
                              <td><?php echo e($data->time); ?></td>
                              <td>
                                <img src="<?php echo e(asset($data->cover_image)); ?>" class="preview-td-img" alt="preview image">
                            </td>
                            <td><?php echo e($data->date); ?></td>
                              <td>
                                <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModalcc" class="btn transparent-btn text-danger text-decoration-underline" data-user-id="<?php echo e($data->id); ?>"
                                    onclick="setDeleteId(this)">Delete</button>
                            </td>
                            </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Table Row Ends -->

   
    
</div>
<!-- end container fluid -->



 <!-- Delete Modal for Each Notification -->
<div class="modal fade" id="DeleteModalcc" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
          
            <div class="modal-body">
                <div class="text-center">
                   
                    <img class="mb-3" src="<?php echo e(asset('/assets')); ?>/images/icons/delete-icon.svg" alt="Delete Icon">
                    <p class="my-4">Are You Sure?</p>
                    <p class="text-muted my-2">Are you sure you want to delete this notification?</p>
                </div>
                <form action="<?php echo e(route('video_delete')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="text" id="delete_id" name="delete_id">
                <div class="d-flex align-items-center mt-5 mb-3">
                    <button type="button" data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                    <button type="submit" class="btn btn-primary submit-btn"><i class="fa-regular fa-circle-check me-2"></i>Submit</button>
            </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer'); ?>


<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.bootstrap5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/datatables.init.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.html5.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/buttons.print.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/jszip.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/pdfmake.min.js"></script>
<script type="text/javascript" src="<?php echo e(asset('/assets')); ?>/js/datatable/vfs_fonts.js"></script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    function setDeleteId(button) {
        var deleteId = button.getAttribute('data-user-id');
        document.getElementById('delete_id').value = deleteId;
    }
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/adbazzar.com/resources/views/admin/add_video.blade.php ENDPATH**/ ?>