<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'            => $this->id,
            'cat_id'        => $this->cat_id,
            'category_name' => $this->category_name,
            'category_img'  => url($this->category_img),
            'category_type' => $this->category_type,
            'products'      => ProductResource::collection($this->whenLoaded('products')),
        ];
    }
}
