<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderplacedResource extends JsonResource
{
    public function toArray(Request $request): array
    {
       
        $orderDetails = json_decode($this->order_details, true);
        return [
            'Bill Id'              => $this->order_random_id,
            'user_id'              => $this->user_id,
            'user_name'            => $this->user_name,
            'product_details_id'   => explode('~', $orderDetails['product_details_id']),
            'product_details_name' => explode('~', $orderDetails['product_details_name']),
            'quantity'             => json_decode($orderDetails['quantity']),
            'amount'               => json_decode($orderDetails['amount']),
            'delivery_address'     => $this->delivery_address,
            'instruction'          => $this->instruction,
            'status'               => $this->status,
            'order_date'           => $this->order_date,
        ];
    }
}
