<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SearchProductResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
 
    public function toArray(Request $request): array
{
    return [
        'id'            => $this->id,
        'category_id'   => $this->category_id,
        'title'         => $this->title,
        'category_name' => $this->category->category_name ?? null,
        'variations'      => $this->variants->map(function ($variant) {
            return [
                'product_id' => $variant->product_id,
                'price'      => $variant->price,
                'title'      => $variant->title,
            ];
        }),
    ];
}

}
