<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\Order;
use App\Models\OrderDetails;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\ProductVarient;
use App\Models\User;
use App\Models\Address;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
class AddressController extends Controller
{
    public function address(Request $request)
    {
        
        $user = auth()->guard('sanctum')->user();
    
        $validated = $request->validate([
            'name'      => 'required|string',
            'house_no'  => 'required|string',
            'road_name' => 'required|string',
            'landmark'  => 'nullable|string',
            'district'  => 'required|string',
            'state'     => 'required|string',
            'pin'       => 'required|numeric|digits:6',
        ]);
    
     
        Address::where('user_id', $user->id)->update(['is_current' => false]);
    
       
        $address             = new Address($validated);
        $address->user_id    = $user->id;
         $address->userid    = $user->user_id;
        $address->is_current = 1;
        $address->save();
    
        return response()->json([
            'status'  => 'success',
            'message' => 'Address added successfully!',
            'data'    => $address,
            'code'    => 201,
        ]);
    }
    public function address_update(Request $request, $id)
    {
        $user = auth()->guard('sanctum')->user();
        $address = Address::where('user_id', $user->id)->findOrFail($id);
        Log::info($address);
        $validated = $request->validate([
            'house_no'  => 'string',
            'road_name' => 'string',
            'landmark'  => 'nullable|string',
            'district'  => 'string',
            'state'     => 'string',
            'pin'       => 'string',
            'name'      => 'string'
        ]);

        $address->update($validated);
        Log::info($address);
        return response()->json([
            'status'  => 'success',
            'message' => 'Address updated successfully!',
            'data'    => $address,
            'code'    => 200,
        ]);
    }
    public function addresses_delete($id)
    {
        $user = auth()->guard('sanctum')->user();
        $address = Address::where('user_id', $user->id)->findOrFail($id);

        $address->delete();

        return response()->json([
            'status' => 'success',
            'message' => 'Address deleted successfully!',
            'code' => 200,
        ]);
    }
    public function addresses()
    {
        $user = auth()->guard('sanctum')->user();
        $addresses = Address::where('user_id', $user->id)->get();

        return response()->json([
            'status' => 'success',
            'message' => 'Addresses retrieved successfully!',
            'data' => $addresses,
            'code' => 200,
        ]);
    }
    public function address_current($id)
    {
        $user = auth()->guard('sanctum')->user();
        Address::where('user_id', $user->id)->update(['is_current' => false]);

        $address = Address::where('user_id', $user->id)->findOrFail($id);
        $address->is_current = true;
        $address->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Current address set successfully!',
            'data' => $address,
            'code' => 200,
        ]);
    }
    public function show_address($id)
    {
        try {
            if (!auth()->guard('sanctum')->check()) {
                return response()->json([
                    'status'  => 'error',
                    'message' => 'Please login!',
                    'data'    => [],
                    'code'    => 401,
                ]);
            }

            $user    = auth()->guard('sanctum')->user();
            $address = Address::where('id', $id)
                ->where('user_id', $user->id)
                ->first();

            if (!$address) {
                return response()->json([
                    'status'  => 'error',
                    'message' => 'Address not found or you do not have permission to view this address.',
                    'code'    => 404,
                ], 404);
            }

            return response()->json([
                'status'  => 'success',
                'data'    => $address,
                'message' => 'Address fetched successfully.',
                'code'    => 200,
            ], 200);

        } catch (\Exception $e) {
            Log::error('Error fetching address: ' . $e->getMessage());

            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch address.',
                'code'    => 500,
            ], 500);
        }
    }
}
