<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Cart;
use App\Models\IncomeWallet;
use App\Models\Product;
use App\Models\ProductVarient;
use App\Models\Address;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\DeliveryFeeMaster;


class CartController extends Controller
{
    // public function cart_add(Request $request)
    // {
    //     if (!auth()->guard('sanctum')->check()) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Please login!',
    //             'code' => 401,
    //         ]);
    //     }

    //     $user = auth()->guard('sanctum')->user();

    //     $request->validate([
    //         'product_id' => 'required|exists:products,product_id',
    //         'quantity' => 'required|integer|min:1',
    //         'variant_id' => 'nullable|exists:product_varients,variant_id',
    //     ]);

    //     $product = Product::where('product_id', $request->product_id)->firstOrFail();
    //     $variant = $request->variant_id
    //         ? ProductVarient::where('variant_id', $request->variant_id)->firstOrFail()
    //         : null;

    //     $price = $variant ? $variant->sell_price : $product->sell_price;

    //     $cart = Cart::where('user_id', $user->user_id)
    //         ->where('product_id', $product->product_id)
    //         ->when($variant, function ($query) use ($variant) {
    //             return $query->where('variant_id', $variant->variant_id);
    //         }, function ($query) {
    //             return $query->whereNull('variant_id');
    //         })
    //         ->first();

    //     $newQuantity = $cart ? $cart->quantity + $request->quantity : $request->quantity;

    //     // Determine available stock from product or variant
    //     $availableStock = $variant ? $variant->stock : $product->stock;

    //     if ($newQuantity > $availableStock) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Requested quantity exceeds available stock.',
    //             'code' => 400,
    //         ], 400);
    //     }


    //     if ($cart) {
    //         $cart->quantity = $newQuantity;
    //         $cart->save();
    //     } else {
    //         $cart = Cart::create([
    //             'user_id' => $user->user_id,
    //             'product_id' => $product->product_id,
    //             'variant_id' => $variant ? $variant->variant_id : null,
    //             'quantity' => $request->quantity,
    //             'price' => $price,
    //         ]);
    //     }

    //     if (!$cart) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Failed to add item to cart.',
    //             'code' => 500,
    //         ], 500);
    //     }

    //     return response()->json([
    //         'status' => 'success',
    //         'data' => [
    //             'cart_id' => $cart->id,
    //             'product_id' => $cart->product_id,
    //             'variant_id' => $cart->variant_id ?? null,
    //             'quantity' => $cart->quantity,
    //             'price' => $cart->price,
    //             'total_price' => $cart->quantity * $cart->price,
    //         ],
    //         'message' => 'Product added to cart.',
    //         'code' => 201,
    //     ], 201);
    // }

   

    // public function cart_delete(Request $request)
    // {
    //     if (!auth()->guard('sanctum')->check()) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Please login!',
    //             'data' => [],
    //             'code' => 401,
    //         ]);
    //     }
    //     $user = auth()->guard('sanctum')->user();
    //     $cart = Cart::where('id', $request->cart_id)
    //         ->where('user_id', $user->user_id)
    //         ->first();
    //     if (!$cart) {
    //         return response()->json([
    //             'status' => 'error',
    //             'data' => [],
    //             'message' => 'Cart item not found.',
    //             'code' => 404,
    //         ], 404);
    //     }
    //     $cart->delete();
    //     return response()->json([
    //         'status' => 'success',
    //         'data' => [],
    //         'message' => 'Product removed from cart.',
    //         'code' => 200,
    //     ], 200);
    // }

    // public function cart()
    // {
    //     $user = auth()->guard('sanctum')->user();
    //     $cartItems = Cart::where('user_id', $user->user_id)
    //         ->whereHas('product')
    //         ->with(['product', 'variant'])
    //         ->where('type', 'normal')
    //         ->get();

    //     $totalPrice = $cartItems->sum(function ($cart) {
    //         return $cart->price * $cart->quantity;
    //     });

    //     $formattedCartItems = $cartItems->map(function ($cart) {
    //         $images = json_decode($cart->product->product_image, true);
    //         $firstImage = is_array($images) && !empty($images) ? url($images[0]) : null;
    //         $subtotal = $cart->price * $cart->quantity;
    //         return [
    //             'id' => $cart->id,
    //             'product_id' => $cart->product->product_id,
    //             'product_name' => $cart->product->title,
    //             'product_image' => $firstImage,
    //             'variant_id' => $cart->variant_id ? $cart->variant_id : null,
    //             'price' => $cart->price,
    //             'quantity' => $cart->quantity,
    //             'subtotal' => $subtotal,
    //         ];
    //     });

    //     return response()->json([
    //         'status' => 'success',
    //         'data' => $formattedCartItems,
    //         'total_price' => $totalPrice,
    //         'message' => $cartItems->isEmpty() ? 'Cart is empty.' : 'Cart items fetched successfully.',
    //         'code' => 200,
    //     ], 200);
    // }
    // public function cart_update(Request $request)
    // {
    //     if (!auth()->guard('sanctum')->check()) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Please login!',
    //             'data' => [],
    //             'code' => 401,
    //         ]);
    //     }

    //     $user = auth()->guard('sanctum')->user();
    //     $cart = Cart::where('id', $request->cart_id)
    //         ->where('user_id', $user->user_id)
    //         ->first();

    //     if (!$cart) {
    //         return response()->json([
    //             'status' => 'error',
    //             'data' => [],
    //             'message' => 'Cart item not found.',
    //             'code' => 404,
    //         ], 404);
    //     }

    //     $product = Product::where('product_id', $cart->product_id)->first();

    //     if (!$product) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Product not found.',
    //             'data' => [],
    //             'code' => 404,
    //         ], 404);
    //     }

    //     if ($request->quantity > $product->stock) {
    //         return response()->json([
    //             'status' => 'error',
    //             'message' => 'Requested quantity exceeds available stock.',
    //             'data' => [],
    //             'code' => 400,
    //         ], 400);
    //     }

    //     $cart->quantity = $request->quantity;

    //     if ($request->has('variant_id')) {
    //         $cart->variant_id = $request->variant_id;
    //     }

    //     $cart->save();

    //     $cartItems = Cart::where('user_id', $user->user_id)->get();
    //     $totalPrice = $cartItems->sum(function ($cart) {
    //         return (float) $cart->price * (int) $cart->quantity;
    //     });

    //     return response()->json([
    //         'status' => 'success',
    //         'data' => [
    //             'cart' => $cart,
    //             'total_price' => number_format($totalPrice, 2),
    //         ],
    //         'message' => 'Cart updated successfully.',
    //         'code' => 200,
    //     ], 200);
    // }


  


     public function cart_add(Request $request)
    {
        if (!auth()->guard('sanctum')->check()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Please login!',
                'code' => 401,
            ]);
        }

        $user = auth()->guard('sanctum')->user();

        $request->validate([
            'product_id' => 'required|exists:products,product_id',
            'quantity' => 'required|integer|min:1',
            'variant_id' => 'nullable|exists:product_varients,variant_id',
        ]);

        $product = Product::where('product_id', $request->product_id)->firstOrFail();
        $variant = $request->variant_id
            ? ProductVarient::where('variant_id', $request->variant_id)->firstOrFail()
            : null;

        $price = $variant ? $variant->sell_price : $product->sell_price;

        $cart = Cart::where('user_id', $user->user_id)
            ->where('product_id', $product->product_id)
            ->when($variant, function ($query) use ($variant) {
                return $query->where('variant_id', $variant->variant_id);
            }, function ($query) {
                return $query->whereNull('variant_id');
            })
            ->first();

        $newQuantity = $cart ? $cart->quantity + $request->quantity : $request->quantity;

        // Determine available stock from product or variant
        $availableStock = $variant ? $variant->stock : $product->stock;

        if ($newQuantity > $availableStock) {
            return response()->json([
                'status' => 'error',
                'message' => 'Requested quantity exceeds available stock.',
                'code' => 400,
            ], 400);
        }

        if ($cart) {
            $cart->quantity = $newQuantity;
            $cart->save();
        } else {
            $cart = Cart::create([
                'user_id'    => $user->user_id,
                'product_id' => $product->product_id,
                'variant_id' => $variant ? $variant->variant_id : null,
                'quantity'   => $request->quantity,
                'price'      => $price,
            ]);
        }

        // // Update product or variant stock
        // if ($variant) {
        //     $variant->stock = $availableStock - $request->quantity;
        //     $variant->save();
        // } else {
        //     $product->stock = $availableStock - $request->quantity;
        //     $product->save();
        // }

        if (!$cart) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to add item to cart.',
                'code' => 500,
            ], 500);
        }

        return response()->json([
            'status' => 'success',
            'data' => [
                'cart_id' => $cart->id,
                'product_id' => $cart->product_id,
                'variant_id' => $cart->variant_id ?? null,
                'quantity' => $cart->quantity,
                'price' => $cart->price,
                'total_price' => $cart->quantity * $cart->price,
            ],
            'message' => 'Product added to cart.',
            'code' => 201,
        ], 201);
    }

    public function cart_delete(Request $request)
    {
        if (!auth()->guard('sanctum')->check()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Please login!',
                'data' => [],
                'code' => 401,
            ]);
        }
        $user = auth()->guard('sanctum')->user();
        $cart = Cart::where('id', $request->cart_id)
            ->where('user_id', $user->user_id)
            ->first();
        if (!$cart) {
            return response()->json([
                'status' => 'error',
                'data' => [],
                'message' => 'Cart item not found.',
                'code' => 404,
            ], 404);
        }

        $product = Product::where('product_id', $cart->product_id)->first();
        if ($cart->variant_id) {
            $variant = ProductVarient::where('variant_id', $cart->variant_id)->first();
            if ($variant) {
                $variant->stock += $cart->quantity;
                $variant->save();
            }
        } else {
            if ($product) {
                $product->stock += $cart->quantity;
                $product->save();
            }
        }

        $cart->delete();
        return response()->json([
            'status' => 'success',
            'data' => [],
            'message' => 'Product removed from cart.',
            'code' => 200,
        ], 200);
    }

    public function cart()
    {
        $user = auth()->guard('sanctum')->user();
        $cartItems = Cart::where('user_id', $user->user_id)
            ->whereHas('product')
            ->with(['product', 'variant'])
            ->where('type', 'normal')
            ->get();

        $totalPrice = $cartItems->sum(function ($cart) {
            return $cart->price * $cart->quantity;
        });

        $formattedCartItems = $cartItems->map(function ($cart) {
            $images = json_decode($cart->product->product_image, true);
            $firstImage = is_array($images) && !empty($images) ? url($images[0]) : null;
            $subtotal = $cart->price * $cart->quantity;
            return [
                'id' => $cart->id,
                'product_id' => $cart->product->product_id,
                'product_name' => $cart->product->title,
                'product_image' => $firstImage,
                'variant_id' => $cart->variant_id ? $cart->variant_id : null,
                'price' => $cart->price,
                'quantity' => $cart->quantity,
                'subtotal' => $subtotal,
            ];
        });

        return response()->json([
            'status' => 'success',
            'data' => $formattedCartItems,
            'total_price' => $totalPrice,
            'message' => $cartItems->isEmpty() ? 'Cart is empty.' : 'Cart items fetched successfully.',
            'code' => 200,
        ], 200);
    }
    public function cart_update(Request $request)
    {
        if (!auth()->guard('sanctum')->check()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Please login!',
                'data' => [],
                'code' => 401,
            ]);
        }

        $user = auth()->guard('sanctum')->user();
        $cart = Cart::where('id', $request->cart_id)
            ->where('user_id', $user->user_id)
            ->first();

        if (!$cart) {
            return response()->json([
                'status' => 'error',
                'data' => [],
                'message' => 'Cart item not found.',
                'code' => 404,
            ], 404);
        }

        $product = Product::where('product_id', $cart->product_id)->first();
        $variant = null;

        // Determine the current stock based on whether a variant is present
        $currentStock = $product->stock;
        if ($cart->variant_id) {
            $variant = ProductVarient::where('variant_id', $cart->variant_id)->first();
            if ($variant) {
                $currentStock = $variant->stock;
            }
        }

        // Calculate the difference in quantity to adjust stock
        $oldQuantity = $cart->quantity;
        $newQuantity = $request->quantity;
        $quantityDifference = $newQuantity - $oldQuantity;

        if ($newQuantity < 1) {
            return response()->json([
                'status' => 'error',
                'message' => 'Quantity must be at least 1.',
                'data' => [],
                'code' => 400,
            ], 400);
        }

        // Check if the new quantity exceeds available stock
        if ($quantityDifference > 0 && $quantityDifference > $currentStock) {
            return response()->json([
                'status' => 'error',
                'message' => 'Requested quantity exceeds available stock.',
                'data' => [],
                'code' => 400,
            ], 400);
        }

        // // Update stock based on the quantity difference
        // if ($variant) {
        //     $variant->stock -= $quantityDifference;
        //     $variant->save();
        // } else {
        //     $product->stock -= $quantityDifference;
        //     $product->save();
        // }

        $cart->quantity = $newQuantity;

        if ($request->has('variant_id')) {
            $cart->variant_id = $request->variant_id;
        }

        $cart->save();

        $cartItems = Cart::where('user_id', $user->user_id)->get();
        $totalPrice = $cartItems->sum(function ($cart) {
            return (float) $cart->price * (int) $cart->quantity;
        });

        return response()->json([
            'status' => 'success',
            'data' => [
                'cart' => $cart,
                'total_price' => number_format($totalPrice, 2),
            ],
            'message' => 'Cart updated successfully.',
            'code' => 200,
        ], 200);
    }



    public function buy_now(Request $request)
    {
        $user = auth()->user();

        $validator = Validator::make($request->all(), [
            'product_id' => 'required|exists:products,product_id',
            'quantity' => 'required|integer|min:1',
            'wallet_type' => 'nullable|in:cash,shopping,both',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Validation failed.',
                'errors' => $validator->errors(),
                'code' => 422
            ], 422);
        }

        $product = Product::where('product_id', $request->product_id)->firstOrFail();
        $price = (float) $product->sell_price;
        $shopWalletAmount = (float) ($product->shop_wallet ?? 0);
        $gstPercent = (float) ($product->gst ?? 0);

        try {
            // Deactivate previous 'product_purchase' type cart items for the user
            Cart::where('user_id', $user->user_id)
                ->where('type', 'product_purchase')
                ->update(['is_active' => 0]);

            // Create a new 'buy now' cart item
            Cart::create([
                'user_id' => $user->user_id,
                'product_id' => $product->product_id,
                'quantity' => $request->quantity,
                'price' => $price * $request->quantity, // This price should ideally be the subtotal for this item
                'type' => 'product_purchase',
                'is_active' => 1
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage(),
                'code' => 500,
            ], 500);
        }

        // Fetch the active 'buy now' cart item
        $cartItem = Cart::where('user_id', $user->user_id)
            ->where('type', 'product_purchase')
            ->where('is_active', 1)
            ->with(['product'])
            ->first(); // Use first() since it's a single product buy now

        if (!$cartItem) {
            return response()->json([
                'status' => 'error',
                'message' => 'Product could not be added to cart for buy now.',
                'data' => [],
                'code' => 400,
            ], 400);
        }

        $wallet = IncomeWallet::where('user_id', $user->user_id)->first();
        $cashWallet = $wallet ? (float) $wallet->cash_wallet : 0;
        $shoppingWallet = $wallet ? (float) $wallet->shopping_wallet : 0;

        $totalPriceIncludingGst = $price * $cartItem->quantity;
        $totalShopWalletEligible = $shopWalletAmount * $cartItem->quantity;

        // Calculate GST for the single product
        $subtotalBeforeGst = round($totalPriceIncludingGst / (1 + ($gstPercent / 100)), 2);
        $totalGstAmount = round($totalPriceIncludingGst - $subtotalBeforeGst, 2);
        $cgst = round($totalGstAmount / 2, 2);
        $sgst = round($totalGstAmount / 2, 2);


        $cartData = [
            [
                'product_id' => $product->product_id,
                'product_name' => $product->title,
                'type' => $cartItem->type,
                'quantity' => $cartItem->quantity,
                'price' => number_format($price, 2),
                'subtotal' => number_format($totalPriceIncludingGst, 2),
            ]
        ];


        $wallet_type = $request->wallet_type;
        $shoppingWalletUsed = 0;
        $cashWalletUsed = 0;
        $remainingAmount = $totalPriceIncludingGst; // Start with total price including GST

        if ($wallet_type === 'shopping') {
            $shoppingWalletUsed = min($shoppingWallet, $totalShopWalletEligible);
            $remainingAmount -= $shoppingWalletUsed;
        } elseif ($wallet_type === 'cash') {
            $cashWalletUsed = min($cashWallet, $totalPriceIncludingGst); // Use total price for cash wallet
            $remainingAmount -= $cashWalletUsed;
        } elseif ($wallet_type === 'both') {
            $shoppingWalletUsed = min($shoppingWallet, $totalShopWalletEligible);
            $remainingAmount -= $shoppingWalletUsed;

            if ($remainingAmount > 0) {
                $cashWalletUsed = min($cashWallet, $remainingAmount);
                $remainingAmount -= $cashWalletUsed;
            }
        }

        // Fetch User Address
        $currentAddress = Address::where('user_id', $user->id)
            ->where('is_current', 1)
            ->first();

        $deliveryFee = 0;
        if ($totalPriceIncludingGst <= 1000) {
            $deliveryFeeMaster = DeliveryFeeMaster::first();
            if ($deliveryFeeMaster) {
                $deliveryFee = (float) $deliveryFeeMaster->delivery_fee;
            }
        }

        $finalTotal = $remainingAmount + $deliveryFee;

        // GST flag from admin
        $is_gst = User::where('role', 'admin')->value('is_gst');

        $data = [
            'order_summary' => $cartData,
            'is_gst' => $is_gst,
            'sub_total' => number_format($totalPriceIncludingGst + $deliveryFee, 2), // Subtotal now includes delivery fee
            'shopping_wallet' => number_format($shoppingWalletUsed, 2),
            'cash_wallet' => number_format($cashWalletUsed, 2),
            'delivery_fee' => number_format($deliveryFee, 2),
            'total' => number_format($finalTotal, 2),
            'address' => $currentAddress ? [
                'name' => $currentAddress->name,
                'house_no' => $currentAddress->house_no,
                'road_name' => $currentAddress->road_name,
                'landmark' => $currentAddress->landmark,
                'district' => $currentAddress->district,
                'state' => $currentAddress->state,
                'pin' => $currentAddress->pin,
            ] : null,
        ];

        if ($is_gst == 1) {
            $data['total_cgst'] = number_format($cgst, 2);
            $data['total_sgst'] = number_format($sgst, 2);
            $data['total_gst'] = number_format($totalGstAmount, 2);
        } else {
            $data['total_cgst'] = null;
            $data['total_sgst'] = null;
            $data['total_gst'] = number_format($totalGstAmount, 2);
        }


        return response()->json([
            'status' => 'success',
            'message' => 'Product added to cart and checkout details fetched successfully.',
            'data' => $data,
            'code' => 201,
        ]);
    }




}
