<?php


namespace App\Http\Controllers\API;
use App\Http\Resources\CatgryByProductResources;
use App\Http\Resources\OrderplacedResource;
use App\Http\Resources\placedOrderResources;
use App\Http\Resources\SubCatByPrdctResources;
use App\Http\Resources\SubCategoryResource;
use App\Models\OrderItem;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\DeliveryFeeResource;
use App\Http\Resources\OrderDetailsResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\CourierResource;
use Illuminate\Support\Facades\Validator;
use App\Models\DeliveryFeeMaster;
use App\Models\Category;
use App\Models\Courier;
use Illuminate\Support\Facades\Log;
use App\Models\Product;

use App\Models\OrderDetails;

class CategoryController extends Controller
{

    public function order_details($user_id)
    {
        try {
            $orderDetails = OrderDetails::where('user_id', $user_id)->get();

            if ($orderDetails->isEmpty()) {
                return response()->json([
                    'status'  => 'success',
                    'data'    => [],
                    'message' => 'No order details found for this user.',
                    'code'    => 200,
                ], 200);
            }

            return response()->json([
                'status'  => 'success',
                'data'    => placedOrderResources::collection($orderDetails),
                'message' => 'Order details fetched successfully.',
                'code'    => 200,
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch order details.',
                'code'    => 500,
            ], 500);
        }
    }

    public function category_product($id)
    {
        try {
            $category = Category::with('products')->find($id);
            if (!$category) {
                return response()->json([
                    'status'  => 'error',
                    'data'    => null,
                    'message' => 'Category not found.',
                    'code'    => 404,
                ], 404);
            }
            return response()->json([
                'status'  => 'success',
                'data'    => new CategoryResource($category),
                'message' => 'Category and its products fetched successfully.',
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Failed to fetch category and products.',
                'code'    => 500,
            ], 500);
        }
    }
    public function subcategory($categoryId)
    {

        $products = Product::where('category_id', $categoryId)->get();
        if (!$products) {
            return response()->json([
                'status'  => 'success',
                'message' => 'products not found.',
                'data'    => [],
                'code'    => 200,
            ], 200);
        }
        return response()->json([
            'status'  => 'success',
            'data'    => SubCategoryResource::collection($products),
            'message' => 'SubCategory fetched successfully.',
            'code'    => 200,
        ], 200);
    }

}