<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
namespace App\Http\Controllers\API;
use App\Http\Resources\CatgryByProductResources;
use App\Http\Resources\SubCatByPrdctResources;
use App\Http\Controllers\Controller;
use App\Models\Address;
use App\Models\OrderDetails;
use App\Models\ProductVarient;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\Product;
use App\Models\Cart;
use App\Models\Wishlist;
use App\Models\User;
use App\Models\Order;
use Illuminate\Support\Facades\Log;

class ProductController extends Controller
{
   
public function Product_by_category(Request $request, $categoryId)
{
    try {
        $user = auth()->guard('sanctum')->user();

        $perPage = $request->query('limit', 8);

        $products = Product::where('category_id', $categoryId)
            ->with(['variants', 'category', 'subcategory'])
            ->where('is_note', 1)
             ->where('stock', '>', 0)
            ->paginate($perPage);

        if ($products->isEmpty()) {
            return response()->json([
                'status'  => 'success',
                'data'    => [],
                'message' => 'No products found for this category.',
                'code'    => 200,
            ]);
        }

       
        $wishlistedProductIds = [];
        if ($user) {
            $wishlistedProductIds = Wishlist::where('user_id', $user->user_id)
                ->whereIn('product_id', $products->pluck('product_id'))
                ->pluck('product_id')
                ->toArray();
        }

     
        $formattedProducts = $products->map(function ($product) use ($wishlistedProductIds) {
            return [
                'id'               => $product->id,
                'product_id'       => $product->product_id,
                'category_id'      => $product->category_id,
                'subcategory_id'   => $product->subcategory_id,
                'product_image'    => $this->getFirstProductImage($product),
                'product_video'    => $product->product_video ? url($product->product_video) : null,
                'brand'            => $product->brand,
                'title'            => $product->title,
                'description'      => $product->description,
                'stock'            => $product->stock,
                'unit'             => $product->unit,
                'mrp'              => $product->mrp,
                'sell_price'       => $product->sell_price,
                'gst'              => $product->gst,
                'discount'         => $product->discount,
                'shop_wallet'      => $product->shop_wallet,
                'payble_amount'    => $product->payble_amount,
                'gst_price'        => $product->gst_price,
                'is_active'        => $product->is_active,
                'is_wishlist'      => in_array($product->product_id, $wishlistedProductIds),
                'category_name'    => $product->category->name ?? null,
                'subcategory_name' => $product->subcategory->name ?? null,
                'variants'         => $product->variants,
            ];
        });

        return response()->json([
            'status'     => 'success',
            'data'       => $formattedProducts,
            'pagination' => [
                'total'        => $products->total(),
                'current_page' => $products->currentPage(),
                'per_page'     => $products->perPage(),
                'last_page'    => $products->lastPage(),
            ],
            'message' => 'Products fetched successfully.',
            'code'    => 200,
        ]);
    } catch (\Exception $e) {
        \Log::error('Error fetching products by category', ['exception' => $e]);

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to fetch products.',
            'code'    => 500,
        ]);
    }
}





    public function Products_by_subcategory(Request $request, $subcategoryId)
{
    try {
        $perPage = $request->query('limit', 8); 

        $products = Product::where('subcategory_id', $subcategoryId)
        ->where('is_note', 1)
            ->with(['variants', 'category'])
              ->where('stock', '>', 0)
            ->paginate($perPage);

        if ($products->isEmpty()) {
            return response()->json([
                'status'  => 'success',
                'data'    => [],
                'message' => 'No products found.',
                'code'    => 200,
            ], 200);
        }

        $user = auth()->guard('sanctum')->user();

        $formattedProducts = $products->getCollection()->map(function ($product) use ($user) {
            return [
                'id'               => $product->id,
                'product_id'       => $product->product_id,
                'category_id'      => $product->category_id,
                'subcategory_id'   => $product->subcategory_id,
                'product_image'    => $this->getFirstProductImage($product),
                'product_video'    => $product->product_video ? url($product->product_video) : null,
                'brand'            => $product->brand,
                'title'            => $product->title,
                'description'      => $product->description,
                'stock'            => $product->stock,
                'unit'             => $product->unit,
                'mrp'              => $product->mrp,
                'sell_price'       => $product->sell_price,
                'gst'              => $product->gst,
                'discount'         => $product->discount,
                'shop_wallet'      => $product->shop_wallet,
                'payble_amount'    => $product->payble_amount,
                'gst_price'        => $product->gst_price,
                'is_active'        => $product->is_active,
                'is_wishlist'      => $user ? Wishlist::where('product_id', $product->product_id)
                                    ->where('user_id', $user->user_id)
                                    ->exists() : false,
                'category_name'    => $product->category->name ?? null,
                'subcategory_name' => $product->subcategory_name ?? null,
                'variants'         => $product->variants,
            ];
        });

        return response()->json([
            'status'  => 'success',
            'data'    => $formattedProducts,
            'meta'    => [
                'current_page' => $products->currentPage(),
                'last_page'    => $products->lastPage(),
                'per_page'     => $products->perPage(),
                'total'        => $products->total(),
            ],
            'message' => 'Products fetched successfully.',
            'code'    => 200,
        ], 200);

    } catch (\Exception $e) {
        Log::error('Error fetching products by subcategory', ['exception' => $e]);

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to fetch products.',
            'code'    => 500,
        ], 500);
    }
}

    private function getFirstProductImage($product)
    {
        $images = json_decode($product->product_image, true);
        return is_array($images) && !empty($images) ? url($images[0]) : null;
    }

public function get_all_products(Request $request)
{
    try {
        $perPage = $request->query('limit', 8);

        $products = Product::with(['variants', 'category'])
          ->where('is_note', 1)
            ->where('stock', '>', 0)
                    ->paginate($perPage);

        if ($products->isEmpty()) {
            return response()->json([
                'status'  => 'success',
                'data'    => [],
                'message' => 'No products found.',
                'code'    => 200,
            ], 200);
        }

        $user = auth()->guard('sanctum')->user();

        $formattedProducts = $products->getCollection()->map(function ($product) use ($user) {
            return [
                'id'               => $product->id,
                'product_id'       => $product->product_id,
                'category_id'      => $product->category_id,
                'subcategory_id'   => $product->subcategory_id,
                'product_image'    => $this->getFirstProductImage($product),
                'product_video'    => $product->product_video ? url($product->product_video) : null,
                'brand'            => $product->brand,
                'title'            => $product->title,
                'description'      => $product->description,
                'stock'            => $product->stock,
                'unit'             => $product->unit,
                'mrp'              => $product->mrp,
                'sell_price'       => $product->sell_price,
                'gst'              => $product->gst,
                'discount'         => $product->discount,
                'shop_wallet'      => $product->shop_wallet,
                'payble_amount'    => $product->payble_amount,
                'gst_price'        => $product->gst_price,
                'is_active'        => $product->is_active,
                'is_wishlist'      => $user ? Wishlist::where('product_id', $product->product_id)
                                                        ->where('user_id', $user->user_id)
                                                        ->exists() : false,
                'category_name'    => $product->category->name ?? null,
                'subcategory_name' => $product->subcategory_name ?? null,
                'variants'         => $product->variants,
            ];
        });

        $paginatedResponse = [
            'status'  => 'success',
            'data'    => $formattedProducts,
            // 'meta'    => [
            //     'current_page' => $products->currentPage(),
            //     'last_page'    => $products->lastPage(),
            //     'per_page'     => $products->perPage(),
            //     'total'        => $products->total(),
            // ],
            'message' => 'All products fetched successfully.',
            'code'    => 200,
        ];

        return response()->json($paginatedResponse, 200);

    } catch (\Exception $e) {
        Log::error('Error fetching all products', ['exception' => $e]);

        return response()->json([
            'status'  => 'error',
            'message' => 'Failed to fetch products.',
            'code'    => 500,
        ], 500);
    }
}

}