<?php

namespace App\Http\Controllers\API;

use App\Http\Resources\BannerResource;

use App\Http\Resources\NotificationResource;

use App\Models\Logo;

use App\Models\Wishlist;

use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Http\Resources\CategoryResource;

use App\Http\Resources\DeliveryFeeResource;

use App\Http\Resources\ProductResource;

use App\Models\BannerImage;

use App\Models\Category;

use App\Models\Membership;

use App\Models\DeliveryFeeMaster;

use App\Models\User;

use App\Models\ContactUs;

use App\Models\Notification;

use App\Models\Product;

use App\Models\ProductVarient;

use Illuminate\Support\Facades\URL;

use Illuminate\Support\Facades\Cache;

class UserController extends Controller

{

//     public function banner()

// {

//     try {

//         $banners = Cache::remember('banners_cache', 3600, function () {

//             return BannerImage::select('id', 'banner_name', 'banner_image')->get();

//         });

//         return response()->json([

//             'status'  => 'success',

//             'data'    => BannerResource::collection($banners),

//             'message' => 'Banners fetched successfully.',

//             'code'    => 200,

//         ], 200);

//     } catch (\Exception $e) {

//         return response()->json([

//             'status'  => 'error',

//             'message' => 'Failed to fetch banners.',

//             'code'    => 500,

//         ], 500);

//     }

// }

public function banner()

{

    try {

        $banners = BannerImage::select('id', 'banner_name', 'banner_image')->get();

        return response()->json([

            'status'  => 'success',

            'data'    => BannerResource::collection($banners),

            'message' => 'Banners fetched successfully.',

            'code'    => 200,

        ], 200);

    } catch (\Exception $e) {

        return response()->json([

            'status'  => 'error',

            'message' => 'Failed to fetch banners.',

            'code'    => 500,

        ], 500);

    }

}

    public function notification()

    {

        try {

            $notifications = Notification::all();

            return response()->json([

                'status'  => 'success',

                'data'    => NotificationResource::collection($notifications),

                'message' => 'Notifications fetched successfully.',

                'code'    => 200,

            ], 200);

        } catch (\Exception $e) {

            return response()->json([

                'status'  => 'error',

                'message' => 'Failed to fetch notifications.',

                'code'    => 500,

            ], 500);

        }

    }

    public function delivery_fee()

    {

        try {

            $deliveryFees = DeliveryFeeMaster::all();

            return response()->json([

                'status'  => 'success',

                'data'    => DeliveryFeeResource::collection($deliveryFees),

                'message' => 'Delivery fees fetched successfully.',

                'code'    => 200,

            ], 200);

        } catch (\Exception $e) {

            return response()->json([

                'status'  => 'error',

                'message' => 'Failed to fetch delivery fees.',

                'code'    => 500,

            ], 500);

        }

    }

    public function category(Request $request)

{

    try {

        $perPage = $request->query('limit', 8); 

        $categories = Category::where('category_type', 1)

            ->distinct()

            ->paginate($perPage);

        if ($categories->isEmpty()) {

            return response()->json([

                'status'  => 'success',

                'data'    => [],

                'message' => 'No categories found.',

                'code'    => 200,

            ], 200);

        }

        return response()->json([

            'status'  => 'success',

            'data'    => CategoryResource::collection($categories->getCollection()),

            'meta'    => [

                'current_page' => $categories->currentPage(),

                'last_page'    => $categories->lastPage(),

                'per_page'     => $categories->perPage(),

                'total'        => $categories->total(),

            ],

            'message' => 'Categories fetched successfully.',

            'code'    => 200,

        ], 200);

    } catch (\Exception $e) {

        return response()->json([

            'status'  => 'error',

            'message' => 'Failed to fetch categories.',

            'code'    => 500,

        ], 500);

    }

}

    public function user_details()

    {

        try {

            $user       = Auth::user();

            $membership = Membership::where('membership_id', $user->membership)->first();

            $domain     = URL::to('/');

            $url        = $domain . '/register/' . $user->user_id; 

           

            return response()->json([

                'status'  => 'success',

                'data'    => [

                    'id'                    => $user->id,

                    'user_id'               => $user->user_id,

                    'name'                  => $user->name,

                    'email'                 => $user->email,

                    'phone_number'          => $user->phone_number,

                    'profile_image'         => $user->profile_image ? url($user->profile_image) : null,

                    'is_subscribed'         => $user->is_subscribed,

                    'subscribed_at'         => $user->subscribed_at,

                    'subscription_end_date' => $user->subscription_end_date,

                    'joining_date'          => $user->created_at,

                    'referral_id'           => $user->referral_id,

                    'membership_title'      => $membership ? $membership->title : null,

                    'membership_image'      => $membership ? url($membership->image) : null,

                    'referral_link'         => $url,

                ],

                'message' => 'User details retrieved successfully',

                'code'    => 200

            ], 200);

        } catch (\Exception $e) {

            return response()->json([

                'status'  => 'error',

                'message' => 'Failed to retrieve user details',

                'code'    => 500,

                'error'   => $e->getMessage()

            ], 500);

        }

    }

    public function products()

    {

        try {

            if (!auth()->guard('sanctum')->check()) {

                return response()->json([

                    'status'  => 'error',

                    'message' => 'Please login!',

                    'data'    => [],

                    'code'    => 401,

                ], 401);

            }

            $user = auth()->guard('sanctum')->user();

            $products = Product::with([

                'wishlist' => function ($query) use ($user) {

                    $query->where('user_id', $user->user_id);

                },

                'variants'

                ->where('stock', '>', 0) 

            ])->get();

            $productsWithWishlistStatus = $products->map(function ($product) {

                $product->is_wishlist = $product->wishlist->isNotEmpty();

                unset($product->wishlist);

                $product->variations = $product->variants->isNotEmpty() ? $product->variants : [];

                return new ProductResource($product);

            })->filter();

            return response()->json([

                'status'  => 'success',

                'data'    => $productsWithWishlistStatus,

                'message' => 'Products fetched successfully.',

                'code'    => 200,

            ], 200);

        } catch (\Exception $e) {

            return response()->json([

                'status'  => 'error',

                'message' => 'Failed to fetch products.',

                'code'    => 500,

            ], 500);

        }

    }

    public function single_product($id)

    {

        try {

            $product = Product::where('product_id', $id)

             ->where('is_note', 1)

              ->where('stock', '>', 0)

            ->first();

            if (!$product) {

                return response()->json([

                    'status'  => 'error',

                    'data'    => null,

                    'message' => 'Product not found',

                    'code'    => 404,

                ], 404);

            }

$product_images = [];

if (!empty($product->product_image)) {

    $images = json_decode($product->product_image, true);

    if (is_array($images)) {

        $product_images = array_map(function ($image) {

            return asset($image);

        }, $images);

    }

}

// Push YouTube URL to the array (if it exists)

if (!empty($product->youtube_url)) {

    $product_images[] = $product->youtube_url;

}

        // Add product video only once

        if (!empty($product->product_video)) {

            $product_images[] = asset($product->product_video);

        }

            $user = auth()->guard('sanctum')->user();

            $is_wishlist = false;

            if ($user) {

                $is_wishlist = Wishlist::where('product_id', $product->product_id)

                    ->where('user_id', $user->user_id)

                    ->exists(); 

            }

            $variants = ProductVarient::where('product_id', $product->product_id)->get();

            return response()->json([

                'status'  => 'success',

                'data'    => [

                    'id'             => $product->id,

                    'product_id'     => $product->product_id,

                    'category_id'    => $product->category_id,

                    'subcategory_id' => $product->subcategory_id,

                    'product_images' => $product_images,

                    // 'product_video'    => $product->product_video ? url($product->product_video) : null,

                    'brand'            => $product->brand,

                    'title'            => $product->title,

                    'description'      => $product->description,

                    'stock'            => $product->stock,

                    // 'youtube_url'      => $product->youtube_url,

                    'unit'             => $product->unit,

                    'mrp'              => $product->mrp,

                    'sell_price'       => $product->sell_price,

                    'gst'              => $product->gst,

                    'discount'         => $product->discount,

                    'shop_wallet'      => $product->shop_wallet,

                    'payble_amount'    => $product->payble_amount,

                    'gst_price'        => $product->gst_price,

                    'is_active'        => $product->is_active,

                    'is_wishlist'      => $is_wishlist,

                    'category_name'    => $product->category_name,

                    'subcategory_name' => $product->subcategory_name,

                    'variants'         => $variants,

                     'is_note'         => $product->is_note,

                ],

                'message'              => 'Product retrieved successfully',

                'code'                 => 200,

            ], 200);

        } catch (\Exception $e) {

            return response()->json([

                'status'  => 'error',

                'message' => 'Failed to retrieve product.',

                'code'    => 500,

            ], 500);

        }

    }

    public function show_logo()

{

    try {

        $logo = Logo::latest()->first();

        if ($logo) {

            $logo->image = $logo->image ? url($logo->image) : null;

        }

        return response()->json([

            'status'  => 'success',

            'message' => 'Logo fetched successfully.',

            'data'    =>$logo,

            'code'    => 200,

        ], 200);

    } catch (\Exception $e) {

        return response()->json([

            'status'  => 'error',

            'message' => 'Failed to fetch Logo.',

            'code'    => 500,

        ], 500);

    }

}

   public function referral_team(Request $request, $membership_title = null)

{

    try {

        $user = Auth::user();

        $referralTeamQuery = User::where('referral_id', $user->user_id);

        if ($membership_title && $membership_title !== 'All') {

            $referralTeamQuery->whereHas('membershipRelation', function ($query) use ($membership_title) {

                $query->where('title', $membership_title);

            });

        }

        $referralTeam = $referralTeamQuery->get();

        $referralTeamData = $referralTeam->map(function ($teamMember) {

            $membership = $teamMember->membershipRelation;

            return [

                'id'                    => $teamMember->id,

                'user_id'               => $teamMember->user_id,

                'name'                  => $teamMember->name,

                'email'                 => $teamMember->email,

                'phone_number'          => $teamMember->phone_number,

                'is_subscribed'         => $teamMember->is_subscribed,

                'subscribed_at'         => $teamMember->subscribed_at,

                'subscription_end_date' => $teamMember->subscription_end_date,

                'profile_image'         => $teamMember->profile_image ? url($teamMember->profile_image) : null,

                'joining_date'          => $teamMember->created_at,

                'membership_title'      => $membership ? $membership->title : null,

                'membership_image'      => $membership ? $membership->image : null,

            ];

        });

        return response()->json([

            'status'  => 'success',

            'message' => 'Referral team retrieved successfully',

            'data'    => $referralTeamData,

            'code'    => 200,

        ], 200);

    } catch (\Exception $e) {

        return response()->json([

            'status'  => 'error',

            'message' => 'Failed to retrieve referral team',

            'code'    => 500,

            'error'   => $e->getMessage()

        ], 500);

    }

}

public function subcategory(Request $request, $id)

{

    $perPage = $request->query('limit', 8);

    $cacheKey = "subcategories_of_{$id}_page_{$request->query('page', 1)}_limit_{$perPage}";

    $subcategories = Cache::remember($cacheKey, 60 * 60, function () use ($id, $perPage) {

        return Category::select('id', 'cat_id', 'subcategory_name', 'category_img')

            ->where('link_to', $id)

            ->paginate($perPage);

    });

    if ($subcategories->isEmpty()) {

        return response()->json([

            'status'  => 'error',

            'data'    => [],

            'message' => 'No subcategories found for this category',

            'code'    => 404

        ]);

    }

    $formatted = $subcategories->getCollection()->map(function ($subcategory) {

        return [

            'category_id'      => $subcategory->id,

            'cat_id'           => $subcategory->cat_id,

            'subcategory_id'   => $subcategory->id,

            'subcategory_name' => $subcategory->subcategory_name,

            'category_img'     => $subcategory->category_img ? url($subcategory->category_img) : null,

        ];

    });

    return response()->json([

        'status'  => 'success',

        'data'    => $formatted,

        'message' => 'Subcategories retrieved successfully',

        'code'    => 200

    ]);

}

public function company_details()

{

    try {

        $contact = ContactUs::where('is_active', 1)->latest()->first();

        if (!$contact) {

            return response()->json([

                'status' => false,

                'message' => 'No company details found.'

            ], 404);

        }

        return response()->json([

            'status' => true,

            'message' => 'Company details fetched successfully.',

            'data' => $contact

        ], 200);

    } catch (\Exception $e) {

        return response()->json([

            'status' => false,

            'message' => 'Something went wrong. Please try again.'

        ], 500);

    }

}

}

