<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\BannerImage;
use App\Models\Logo;
use App\Models\ProductPurchase;
use Illuminate\Http\Request;
use App\Models\Notification;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\Models\DeliveryFeeMaster;
class DashboardController extends Controller
{
public function purchase_store_post(Request $request)
{
    $request->validate([
        'customer_name' => 'required|string|max:255',
        'phone_number'  => 'required|string|max:20',
        'address'       => 'nullable|string|max:500',
        'gstin'         => 'nullable|string|max:50',
        'agency_name'   => 'required|string|max:255',
    ]);
    $user = auth()->user();
    $branch = null;
    if ($user->role === 'sakthi') {
        $branch = 'Sakthi Super Mart';
    } elseif ($user->role === 'smart_world') {
        $branch = 'SMARTWORLD';
    } elseif ($user->role === 'smart_world_gift') {
        $branch = 'SMARTWORLD - Stationary & Gifts';
    } elseif ($user->role === 'yoga_naturals') {
        $branch = 'yoga naturals';
    }
    try {
        ProductPurchase::create([
            'customer_name' => $request->customer_name,
            'phone_number'  => $request->phone_number,
            'address'       => $request->address,
            'gstin'         => $request->gstin,
            'branch'      => $branch,
            'agency_name' => $request->agency_name,
        ]);
        return redirect()->back()->with('success', 'Purchase created successfully!');
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Something went wrong while creating the purchase. Please try again.');
    }
}
public function purchase_update(Request $request, $id)
{
    $request->validate([
        'customer_name' => 'required|string|max:255',
        'agency_name' => 'nullable|string|max:255',
        'phone_number'  => 'required|string|max:20',
        'address'       => 'nullable|string|max:500',
        'gstin'         => 'nullable|string|max:50',
    ]);
    $user = auth()->user();
    $branch = match ($user->role) {
        'sakthi' => 'Sakthi Super Mart',
        'smart_world' => 'SMARTWORLD',
        'smart_world_gift' => 'SMARTWORLD - Stationary & Gifts',
        'yoga_naturals' => 'yoga naturals',
        default => null
    };
    $purchase = ProductPurchase::findOrFail($id);
    $purchase->update([
        'customer_name' => $request->customer_name,
        'phone_number'  => $request->phone_number,
        'address'       => $request->address,
        'gstin'         => $request->gstin,
        'agency_name'   => $request->agency_name,
        'branch'        => $branch,
    ]);
    return redirect()->route('purchase_parties')->with('success', 'Purchase updated successfully!');
}
// public function purchase_update(Request $request, $id)
// {
//     $request->validate([
//         'customer_name' => 'required|string|max:255',
//         'phone_number'  => 'required|string|max:20',
//         'address'       => 'nullable|string|max:500',
//         'gstin'         => 'nullable|string|max:50',
//     ]);
//     $user = auth()->user();
//     $branch = null;
//     if ($user->role === 'sakthi') {
//         $branch = 'Sakthi Super Mart';
//     } elseif ($user->role === 'smart_world') {
//         $branch = 'SMARTWORLD';
//     } elseif ($user->role === 'smart_world_gift') {
//         $branch = 'SMARTWORLD - Stationary & Gifts';
//     } elseif ($user->role === 'yoga_naturals') {
//         $branch = 'yoga naturals';
//     }
//     $purchase = ProductPurchase::findOrFail($id);
//     $purchase->update([
//         'customer_name' => $request->customer_name,
//         'phone_number'  => $request->phone_number,
//         'address'       => $request->address,
//         'gstin'         => $request->gstin,
//         'branch'        => $branch, // ✅ keep it updated too!
//     ]);
//     return redirect()->route('purchase_parties')->with('success', 'Purchase updated successfully!');
// }
    public function delivery_post(Request $request)
    {
        $validatedData = $request->validate([
            'delivery_fee' => 'required|numeric',
        ]);
        DeliveryFeeMaster::create([
            'delivery_fee' => $request->delivery_fee,
        ]);
        return redirect()->route('delivery_price_page')->with('successmessage', 'Delivery Fee added successfully!');
    }
    public function notification_post(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'notification_title' => 'required|string|max:255',
            'description' => 'required|string',
            'from_date' => 'nullable|date',
            'to_date' => 'nullable|date|after_or_equal:from_date',
            'type' => 'required|in:notification,popup',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $notification = new Notification();
        $notification->title = $request->input('notification_title');
        $notification->description = $request->input('description');
        $notification->type = $request->input('type');
        $notification->from_date = $request->input('from_date');
        $notification->to_date = $request->input('to_date');
        $notification->save();
        return redirect()->route('notification')->with('success', 'Notification added successfully.');
    }
    public function delivery_price_page()
    {
        $deliveries = DeliveryFeeMaster::all();
        return view('admin.delivery_price', compact('deliveries'));
    }
    public function delivery_fee_post(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'town' => 'required|string|max:255',
            'add_area' => 'required|string|max:255|unique:delivery_fee_masters,area',
            'delivery_fee' => 'required|numeric|min:0',
        ], [
            'add_area.unique' => 'The area already exists in the database. Please choose a different area.',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $deliveryFeeMaster = new DeliveryFeeMaster();
        $deliveryFeeMaster->town = $request->town;
        $deliveryFeeMaster->area = $request->add_area;
        $deliveryFeeMaster->delivery_fee = $request->delivery_fee;
        $deliveryFeeMaster->save();
        return redirect()->route('delivery_fee')->with('success', 'Delivery fee added successfully.');
    }
    public function delivery_fee_delete($id)
    {
        $delivery = DeliveryFeeMaster::find($id);
        if ($delivery) {
            $delivery->delete();
            return redirect()->back()->with('success', 'Delivery fee deleted successfully.');
        }
        return redirect()->back()->with('error', 'Delivery fee not found.');
    }
    public function banner_delete($id)
    {
        $logo = BannerImage::find($id);
        if (!$logo) {
            return redirect()->back()->with('error', 'Logo not found.');
        }
        // Delete the image file
        $imagePath = public_path($logo->banner_image); // image field contains 'assets/images/banners/filename.jpg'
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }
        // Delete the database record
        $logo->delete();
        return redirect()->back()->with('success', 'Logo deleted successfully.');
    }
    public function notification_delete($id)
    {
        $notification = Notification::findOrFail($id);
        if ($notification) {
            $notification->delete();
            return redirect()->route('notification')->with('success', 'Notification deleted successfully.');
        }
        return redirect()->back()->with('error', 'Error not found');
    }
    public function banner_post(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'banner_name' => 'required|string|max:255',
            'banner_img' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $imagePath = null;
        if ($request->hasFile('banner_img')) {
            $file = $request->file('banner_img');
            if (!$file->isValid()) {
                return redirect()->back()->with('error', 'File upload failed.');
            }
            $fileName = time() . '_' . $file->getClientOriginalName();
            $destinationPath = public_path('assets/images/banners');
            $file->move($destinationPath, $fileName);
            $imagePath = 'assets/images/banners/' . $fileName;
        }
        $banner = new BannerImage();
        $banner->banner_name = $request->input('banner_name');
        $banner->banner_image = $imagePath;
        $banner->save();
        return redirect()->back()->with('success', 'Banner added successfully.');
    }
}