<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Mail\RegistrationSuccessMail;
use App\Models\IncomeWallet;
use App\Models\Membership;
use App\Models\Address;
use App\Models\shopWalletIncome;
use App\Models\UserSubscription;
use App\Models\CashWalletIncome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Support\Facades\Crypt;
use App\Mail\OtpMail;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Models\Employee;
use App\Models\Product;
class LoginController extends Controller
{
    public function reset_password_handle(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => ['required', 'string', 'min:6'],
            'new_pwd' => ['required', 'string', 'min:6', 'confirmed', 'regex:/[!@#$%^&*(),.?":{}|<>]/'],
            'new_pwd_confirmation' => ['required', 'string', 'min:6'],
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->with('error', $validator->errors()->first());
        }
        $user = Auth::user();
        if (!Hash::check($request->input('password'), $user->password)) {
            return redirect()->back()
                ->withErrors(['password' => 'The old password is incorrect.'])
                ->withInput();
        }
        $user->password = Hash::make($request->input('new_pwd'));
        $user->save();
        return redirect()->route('dashboard')
            ->with('success', 'Password has been updated successfully.');
    }
    public function profile_update(Request $request)
{
    $validator = Validator::make($request->all(), [
        'name'         => 'nullable|string|max:255',
        'email'        => 'nullable|email|max:255',
        'phone_number' => 'nullable|numeric',
        'building_name'=> 'nullable|string|max:255',
        'gst_number'   => 'nullable|string|max:255',
        'logo'         => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048'
    ]);
    if($validator->fails()){
        return back()->with('error',$validator->errors()->first());
    }
    $user = auth()->user();
    // Image Upload
    if($request->hasFile('logo')){
        if($user->logo && file_exists(public_path($user->logo))){
            unlink(public_path($user->logo)); // delete old image
        }
        $file = $request->file('logo');
        $fileName = time().'.'.$file->getClientOriginalExtension();
        $file->move('uploads/profile/',$fileName);
        $user->logo = 'uploads/profile/'.$fileName;
    }
    // Save fields
    $user->update([
        'name'         => $request->name,
        'email'        => $request->email,
        'phone_number' => $request->phone_number,
        'building_name'=> $request->building_name,
        'gst_number'   => $request->gst_number,
    ]);
    return redirect()->route('profile')->with('success','Profile Updated Successfully!');
}
//     public function profile_update(Request $request)
// {
//     $validator = Validator::make($request->all(), [
//        'name'         => 'nullable|string|max:255',
//        'email'        => 'nullable|email|max:255',
//        'phone_number' => 'numeric',
//        'address'      => 'nullable|string|max:255',
//        'gst_number'   => 'nullable|max:255',
//     ]);
//     if ($validator->fails()) {
//         return redirect()->back()->with('error', $validator->errors()->first());
//     }
//     $user = auth()->user(); // Get the authenticated user
//     if (!$user) {
//         return redirect()->route('admin.login')->with('error', 'You need to be logged in to update your profile.');
//     }
//     // Update user fields
//     $user->name         = $request->name;
//     $user->email        = $request->email;
//     $user->phone_number = $request->phone_number;
//     $user->building_name      = $request->address;
//     $user->gst_number   = $request->gst_number;
//     $user->save();
//     return redirect()->route('profile')->with('success', 'Profile updated successfully!');
// }
    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->flush();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login');
    }
    public function login_sendotp(Request $request)
    {
        try {
            $request->validate([
                'email' => 'required|email',
                'password' => 'required',
            ]);
            $user = User::where('email', $request->input('email'))->first();
            if (!$user || !Hash::check($request->input('password'), $user->password)) {
                return response()->json(['status' => 'error', 'message' => 'Invalid email or password']);
            }
            if (!$user) {
                return response()->json(['status' => 'error', 'message' => 'User not found']);
            }
            $otp = '123456';
            $user->otp = Crypt::encryptString($otp);
            $user->otp_expires_at = now()->addMinutes(1);
            $user->save();
            return response()->json(['status' => 'success', 'message' => 'OTP sent successfully']);
        } catch (\Exception $e) {
            return response()->json(['status' => 'error', 'message' => 'An error occurred while sending OTP. Please try again.']);
        }
    }
    public function login_verifyotp(Request $request)
    {
        try {
            $request->validate([
                'email' => 'required|email',
                'otp' => 'required|numeric',
                'password' => 'required',
            ]);
            $user = User::where('email', $request->input('email'))->first();
            if (!$user || !Hash::check($request->input('password'), $user->password)) {
                return response()->json(['status' => 'error', 'message' => 'Invalid credentials']);
            }
            if (now()->greaterThan($user->otp_expires_at)) {
                return response()->json(['status' => 'error', 'message' => 'OTP has expired']);
            }
            $decryptedOtp = Crypt::decryptString($user->otp);
            if ($request->input('otp') != $decryptedOtp) {
                return response()->json(['status' => 'error', 'message' => 'Invalid OTP']);
            }
            $user->otp = null;
            $user->otp_expires_at = null;
            $user->save();
            Auth::login($user);
            if ($user->role === 'admin') {
                $redirectUrl = route('dashboard');
            } elseif ($user->role === 'sakthi') {
                $redirectUrl = route('dashboard');
            } elseif ($user->role === 'smart_world') {
                $redirectUrl = route('dashboard');
            } elseif ($user->role === 'smart_world_gift') {
                $redirectUrl = route('dashboard');
            } elseif ($user->role === 'yoga_naturals') {
                $redirectUrl = route('dashboard');
            } else {
                $redirectUrl = route('dashboard');
            }
            return response()->json(['status' => 'success', 'redirect_url' => $redirectUrl]);
        } catch (\Exception $e) {
            return response()->json(['status' => 'error', 'message' => 'An error occurred while verifying OTP. Please try again.']);
        }
    }
    public function users_store(Request $request)
    {
        Log::info('Received Membership ID:', ['membership_id' => $request->membership_id]);
        $validator = Validator::make($request->all(), [
            'name'          => 'required|string|max:255',
            'email'         => 'required|email|unique:users,email',
            'password'      => 'required|min:6|confirmed',
            'membership_id' => 'nullable|exists:memberships,id',
            'referral_id'   => 'nullable|string|max:255|exists:users,user_id',
            'phone'         => 'required|string|max:15|unique:users,phone_number',
            'address'       => 'nullable|string|max:255',
            'payment_mode'  => 'nullable|string|max:255',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        // Generate unique user ID
        $latestUser = User::where('user_id', 'LIKE', 'AD%')
            ->orderByDesc('user_id')
            ->first();
        if ($latestUser && preg_match('/AD(\d+)/', $latestUser->user_id, $matches)) {
            $nextNumber = intval($matches[1]) + 1;
        } else {
            $nextNumber = 2025;
        }
        do {
            $UserID = 'AD' . $nextNumber;
            $nextNumber++;
        } while (User::where('user_id', $UserID)->exists());
        $membership = null;
        if ($request->membership_id) {
            $membership = Membership::find($request->membership_id);
            if (!$membership) {
                return redirect()->back()->with('error', 'Invalid Membership ID');
            }
        }
        $referralName = null;
        if ($request->referral_id) {
            $referralUser = User::where('user_id', $request->referral_id)->first();
            if ($referralUser) {
                $referralName = $referralUser->name;
            }
        }
        // Create User
        $user                = new User();
        $user->user_id       = $UserID;
        $user->name          = $request->name;
        $user->email         = $request->email;
        $user->password      = Hash::make($request->password);
        $user->membership    = $membership ? $membership->membership_id : null;
        $user->referral_id   = $request->referral_id;
        $user->phone_number  = $request->phone;
        $user->referral_name = $referralName;
        $user->is_active     = 1;
        $user->role          = 'user';
        $user->is_subscribed = $membership ? 1 : 0;
        $user->save();
        if ($membership) {
            try {
                $subscription                 = new UserSubscription();
                $subscription->user_id        = $user->user_id;
                $subscription->name           = $user->name;
                $subscription->membership_id  = $membership->membership_id;
                $subscription->title          = $membership->title;
                $subscription->amount         = $membership->amount;
                $subscription->days           = $membership->days;
                $subscription->transaction_id = null;
                $subscription->payment_image  = null;
                $subscription->payment_mode   = $request->payment_mode;
                $subscription->status         = "Accepted";
                $subscription->remark         = "Admin added";
                $subscription->action_at      = now();
                $subscription->is_active      = 1;
                $subscription->save();
                Log::info('Subscription added automatically:', ['subscription' => $subscription]);
                // $user->subscribed_at         = Carbon::now();
                // $user->subscription_end_date = Carbon::now()->addYear();
                // $user->save();

                $user->subscribed_at = Carbon::now();

    
    if ($membership->membership_id === 'MEMZ6965') {
       
        $user->subscription_end_date = Carbon::now()->addMonths(6);
    } else {
      
        $user->subscription_end_date = Carbon::now()->addYear();
    }

    $user->save();
                 Log::info('user:', ['subscription' => $user]);
                if (!empty($user->referral_id)) {
                    Log::info('Processing referral income for admin-added subscription.', ['user_id' => $user->user_id]);
                    $this->referral_income($user->user_id, $membership->id);
                }
                if (!is_null($membership->welcome_bonus) && $membership->welcome_bonus > 0) {
                    Log::info('Processing welcome income for admin-added subscription.', ['user_id' => $user->user_id]);
                    $this->welcome_income($user->user_id, $membership->id);
                }
            } catch (\Exception $e) {
                Log::error('Exception Error in auto-subscription: ' . $e->getMessage());
            }
        }
        try {
            Mail::to($user->email)->send(new RegistrationSuccessMail($user));
            Log::info('Registration success email sent.', ['email' => $user->email]);
        } catch (\Exception $e) {
            Log::error('Error sending registration success email: ' . $e->getMessage());
        }
        return redirect()->route('user_management')->with('success', 'User Created successfully');
    }
    public function referral_income($user_id, $membership_id)
    {
        try {
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::error("User not found with user_id: {$user_id}");
                return false;
            }
            $membership = Membership::find($membership_id);
            if (!$membership) {
                Log::error("Membership not found: {$membership_id}");
                return false;
            }
            $reward = $membership->amount * $membership->referral_percentage / 100;
            $referralIncome = new CashWalletIncome();
            $referralIncome->user_id = $user->referral_id;
            $referralIncome->membership_id = $membership->membership_id;
            $referralIncome->amount = $reward;
            $referralIncome->remark = "Referral Income";
            $referralIncome->description = $user_id;
            $referralIncome->type = "referral";
            $referralIncome->save();
            Log::info("Referral income added for user_id: {$user_id}, amount: {$reward}");
            $income_wallet = IncomeWallet::where('user_id', $user->referral_id)->first();
            if ($income_wallet) {
                $income_wallet->referral_income += $reward;
                $income_wallet->cash_wallet += $reward;
                $income_wallet->save();
                Log::info("Updated referral income wallet for user_id: {$user_id}, new amount: {$income_wallet->referral_income}");
            } else {
                $wallet = new IncomeWallet();
                $wallet->user_id = $user_id;
                $wallet->referral_income = $reward;
                $wallet->cash_wallet = $reward;
                $wallet->save();
                Log::info("Created new incoFme wallet for user_id: {$user_id} with amount: {$reward}");
            }
            return true;
        } catch (\Exception $e) {
            Log::error("Exception in referral_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace' => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
    public function welcome_income($user_id, $membership_id)
    {
        try {
            Log::info("welcome_income started");
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::info("User not found with user_id: {$user_id}");
                return false;
            }
            Log::info("welcome_income startedcccccccccccccccccccccccc");
            $membership = Membership::find($membership_id);
            if (!$membership) {
                Log::info("Membership not found: {$membership_id}");
                return false;
            }
            Log::info("welcome_income startedxxxxxxxxxxxxxxxxxxxx");
            $welcome_bonus = $membership->welcome_bonus;
            $welcomeIncome = new shopWalletIncome();
            $welcomeIncome->user_id = $user_id;
            $welcomeIncome->membership_id = $membership->membership_id;
            $welcomeIncome->amount = $welcome_bonus;
            $welcomeIncome->remark = "Welcome Income";
            $welcomeIncome->type = "credit";
            $welcomeIncome->save();
            Log::info("Welcome income added for user_id: {$user_id}, amount: {$welcome_bonus}");
            $income_wallet = IncomeWallet::where('user_id', $user_id)->first();
            if ($income_wallet) {
                $income_wallet->welcome_income += $welcome_bonus;
                $income_wallet->shopping_wallet += $welcome_bonus;
                $income_wallet->save();
                Log::info("Updated income wallet for user_id: {$user_id}, new welcome income: {$income_wallet->welcome_income}");
            } else {
                $wallet = new IncomeWallet();
                $wallet->user_id = $user_id;
                $wallet->welcome_income = $welcome_bonus;
                $wallet->shopping_wallet = $welcome_bonus;
                $wallet->save();
                Log::info("Created new income wallet for user_id: {$user_id} with welcome income: {$welcome_bonus}");
            }
            return true;
        } catch (\Exception $e) {
            Log::info("Exception in welcome_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace' => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
}
