<?php

namespace App\Http\Controllers;

use App\Mail\RegistrationSuccessMail;

use App\Models\BankDetails;

use App\Models\Branch;

use App\Models\CashWalletIncome;

use App\Models\ContactUs;

use App\Models\EditWallet;

use App\Models\Employee;

use App\Models\IncomeWallet;

use App\Models\Membership;

use App\Models\MyPurchase;

use App\Models\OrderTrack;

// use App\Models\Product;

use App\Models\ProductPurchase;

use App\Models\shopWalletIncome;

use App\Models\StockSummary;

use App\Models\Video;

use App\Models\OfflineSale;

use App\Models\WithdrawRequest;

use Illuminate\Support\Facades\Log;

use Illuminate\Support\Facades\DB;

use App\Models\BannerImage;

use App\Models\DeliveryFeeMaster;

use App\Models\Notification;

use App\Models\User;

// use App\Models\Product;   

use App\Models\Category;

use App\Models\UserSubscription;

use App\Models\Address;

use App\Models\Logo;

use App\Models\OrderDetails;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\URL;

use Illuminate\Support\Facades\Validator;

use App\Http\Controllers\API\CheckoutController;

use App\Http\Controllers\Profile\ShiprocketController;

use App\Traits\BackUpTrait;

use App\Models\MyPurchaseItem;

use App\Models\Product;

use Carbon\Carbon;

class AdminController extends Controller

{

    use BackUpTrait;

    public function stock_summary()

    {

        $user = auth()->user();

        $products = Product::with(['variants', 'category'])

            ->when($user->role !== 'admin', function ($query) use ($user) {

                if ($user->role === 'sakthi') {

                    $query->where('branch_name', 'Sakthi Super Mart');

                } elseif ($user->role === 'smart_world') {

                    $query->where('branch_name', 'SMARTWORLD');

                } elseif ($user->role === 'chendur_traders') {

                    $query->where('branch_name', 'CHENDUR TRADERS');

                } elseif ($user->role === 'yoga_naturals') {

                    $query->where('branch_name', 'yoga naturals');

                }

            })

            ->orderBy('product_id', 'asc')

            ->get();

        return view('admin.stock_summary', compact('products'));

    }

    // public function stock_details($product_id)

// {

//     Log::info("Fetching stock details for product ID: {$product_id}");

//     $product = Product::where('product_id', $product_id)->firstOrFail();

//     Log::info("Product found", ['product' => $product->only(['id', 'name', 'sku', 'product_id'])]);

//     $realProductId = $product->id; // ✅ use primary key for purchase_items

//     $purchases = MyPurchaseItem::with('purchase')

//         ->where('product_id', $realProductId) // ✅ FIXED

//         ->get()

//         ->map(function ($p) {

//             return [

//                 'date'     => $p->created_at,

//                 'type'     => 'Purchase',

//                 'quantity' => (int) $p->quantity,

//                 'ref'      => $p->purchase->invoice_number ?? 'N/A',

//             ];

//         });

//     Log::info("Purchase transactions", $purchases->toArray());

//     $sales = collect();

//     $offlineSales = OfflineSale::get();

//     foreach ($offlineSales as $sale) {

//         if (isset($sale->sale_items) && is_array($sale->sale_items)) {

//             foreach ($sale->sale_items as $item) {

//                 if (

//                     (isset($item['product_id']) && $item['product_id'] == $product_id) ||

//                     (isset($item['item_identifier']) && $item['item_identifier'] == $product_id) ||

//                     (isset($item['product_id_main']) && $item['product_id_main'] == $product_id)

//                 ) {

//                     $sales->push([

//                         'date'     => $sale->created_at,

//                         'type'     => 'Sale',

//                         'quantity' => (int) ($item['quantity'] ?? 0),

//                         'ref'      => $sale->order_id ?? 'N/A',

//                     ]);

//                 }

//             }

//         }

//     }

//     Log::info("Sale transactions", $sales->toArray());

//     // Merge & sort

//     $transactions = $purchases->concat($sales)->sortBy('date')->values();

//     Log::info("Final merged transactions", $transactions->toArray());

//     return view('admin.stock_details', compact('product', 'transactions'));

// }

    /**

     * Fetches and merges all stock transactions.

     */

    public function stock_details($product_id)

    {

        Log::info("Fetching stock details for product ID: {$product_id}");

        // Find the product using the external product_id first, then get its primary ID.

        $product = Product::where('product_id', $product_id)->firstOrFail();

        $realProductId = $product->id; // Use the product primary key for relational queries

        // --- PURCHASE TRANSACTIONS ---

        $purchases = MyPurchaseItem::with('purchase')

            ->where('product_id', $realProductId) // Use realProductId

            ->get()

            ->map(function ($p) {

                return [

                    'date' => $p->created_at,

                    'type' => 'Purchase',

                    'quantity' => (int) $p->quantity,

                    'ref' => $p->purchase->invoice_number ?? 'N/A',

                ];

            });

        // --- SALE TRANSACTIONS ---

        $sales = collect();

        $offlineSales = OfflineSale::get();

        foreach ($offlineSales as $sale) {

            if (isset($sale->sale_items) && is_array($sale->sale_items)) {

                foreach ($sale->sale_items as $item) {

                    // Need to check against the external product_id as used in the sales data

                    if (

                        (isset($item['product_id']) && $item['product_id'] == $product_id) ||

                        (isset($item['item_identifier']) && $item['item_identifier'] == $product_id) ||

                        (isset($item['product_id_main']) && $item['product_id_main'] == $product_id)

                    ) {

                        $sales->push([

                            'date' => $sale->created_at,

                            'type' => 'Sale',

                            'quantity' => (int) ($item['quantity'] ?? 0),

                            'ref' => $sale->order_id ?? 'N/A',

                        ]);

                    }

                }

            }

        }

        // --- ADMIN ADJUSTMENT TRANSACTIONS ---

        $adminAdjustments = StockSummary::where('product_id', $realProductId) // Use realProductId

            ->whereIn('transaction_type', ['Admin Add', 'Admin Reduce'])

            ->get()

            ->map(function ($a) {

                return [

                    'date' => $a->created_at,

                    'type' => $a->transaction_type,

                    'quantity' => (int) $a->quantity,

                    'ref' => $a->order_id ?? 'Admin Update',

                ];

            });

        // --- MERGE ALL TRANSACTIONS ---

        $transactions = $purchases->concat($sales)->concat($adminAdjustments);

        // Sort ascending for calculation in the view (this step is CRITICAL)

        $transactions = $transactions->sortBy(function ($t) {

            return Carbon::parse($t['date'])->timestamp;

        })->values();

        Log::info("Final merged transactions", $transactions->toArray());

        return view('admin.stock_details', compact('product', 'transactions'));

    }

    public function products()

    {

        $user = auth()->user();

        $products = Product::with(['variants', 'category'])

            ->when($user->role !== 'admin', function ($query) use ($user) {

                if ($user->role === 'sakthi') {

                    $query->where('branch_name', 'Sakthi Super Mart');

                } elseif ($user->role === 'smart_world') {

                    $query->where('branch_name', 'SMARTWORLD');

                } elseif ($user->role === 'chendur_traders') {

                    $query->where('branch_name', 'CHENDUR TRADERS');

                } elseif ($user->role === 'yoga_naturals') {

                    $query->where('branch_name', 'yoga naturals');

                }

            })

           ->orderBy('product_id', 'desc')

            ->get();

        return view('admin.products', compact('products'));

    }

    public function runBackup()

    {

        $project = $this->backupProject();

        $database = $this->backupDatabase();

        return response()->json([

            'project_backup' => $project,

            'db_backup' => $database,

        ]);

    }

    public function add_employee()

    {

        $user = auth()->user();

        $branches = Branch::all();

        $employees = Employee::latest()

            ->when($user->role !== 'admin', function ($query) use ($user) {

                if ($user->role === 'sakthi') {

                    $query->where('branch', 'Sakthi Super Mart');

                } elseif ($user->role === 'smart_world') {

                    $query->where('branch', 'SMARTWORLD');

                } elseif ($user->role === 'smart_world_gift') {

                    $query->where('branch', 'SMARTWORLD - Stationary & Gifts');

                } elseif ($user->role === 'chendur_traders') {

                    $query->where('branch', 'CHENDUR TRADERS');   // <-- 🔥 Correct branch name

                } elseif ($user->role === 'yoga_naturals') {

                    $query->where('branch', 'Yogaa Naturals');     // if DB name same update here

                }

            })

            ->get();

        return view('admin.add_employee', compact('branches', 'employees'));

    }

    // public function add_employee()

    // {

    //     $user = auth()->user();

    //     $branches = Branch::all();

    //     $employees = Employee::latest()

    //         ->when($user->role !== 'admin', function ($query) use ($user) {

    //             if ($user->role === 'sakthi') {

    //                 $query->where('branch', 'Sakthi Super Mart');

    //             } elseif ($user->role === 'smart_world') {

    //                 $query->where('branch', 'SMARTWORLD');

    //             } elseif ($user->role === 'chendur_traders') {

    //                 $query->where('branch', 'chendur_traders');

    //             } elseif ($user->role === 'yoga_naturals') {

    //                 $query->where('branch', 'yoga naturals');

    //             }

    //         })

    //         ->get();

    //     return view('admin.add_employee', compact('branches', 'employees'));

    // }

    public function login()

    {

        return view('admin.login');

    }

    public function user_purchase_history($user_id)

    {

        $user = User::where('user_id', $user_id)->firstOrFail();

        $offlineSales = OfflineSale::where('user_id', $user->user_id)

            ->with('user')

            ->orderBy('created_at', 'desc')

            ->get();

        return view('admin.user_purchase_history', compact('offlineSales', 'user'));

    }

    public function about_us()

    {

        return view('admin.about_us');

    }

    public function delete_user()

    {

        return view('admin.delete_user');

    }

    public function user_delete_post(Request $request)

    {

        $request->validate([

            'phone' => 'required|string'

        ]);

        $user = User::where('phone_number', $request->phone)->first();

        if (!$user) {

            return redirect()->back()->with('error', 'User not found!');

        }

        $user->delete();

        return redirect()->back()->with('success', 'User deleted successfully.');

    }

    public function privacy_policy()

    {

        return view('admin.privacy_policy');

    }

    public function terms_condition()

    {

        return view('admin.terms_condition');

    }

    public function add_branch()

    {

        $banners = Branch::all();

        return view('admin.branches', compact('banners'));

    }

    public function refund_policy()

    {

        return view('admin.refund_policy');

    }

    public function updateGstStatus(Request $request)

    {

        $user = Auth::user();

        $user->is_gst = $request->is_gst == 'true' ? 1 : 0;

        $user->save();

        return response()->json(['success' => true, 'is_gst' => $user->is_gst]);

    }

    public function sales()

    {

        return view('admin.sales');

    }

    public function register_form(Request $request)

    {

        Log::info('Received request for registration.', $request->all());

        $validator = Validator::make($request->all(), [

            'referral_id' => 'nullable|exists:users,user_id',

            'name' => 'required|string|max:255',

            'email' => 'required|email|unique:users,email',

            'phone_number' => 'required|unique:users,phone_number',

            'password' => 'required',

            'confirm_password' => 'required|same:password',

        ]);

        if ($validator->fails()) {

            return redirect()->back()->withErrors($validator)->withInput();

        }

        DB::beginTransaction();

        try {

            $latestUser = User::where('user_id', 'LIKE', 'AD%')

                ->orderByDesc('user_id')

                ->first();

            if ($latestUser && preg_match('/AD(\d+)/', $latestUser->user_id, $matches)) {

                $nextNumber = intval($matches[1]) + 1;

            } else {

                $nextNumber = 2025;

            }

            do {

                $UserID = 'AD' . $nextNumber;

                $nextNumber++;

            } while (User::where('user_id', $UserID)->exists());

            $referralName = null;

            if ($request->referral_id) {

                $referralUser = User::where('user_id', $request->referral_id)->first();

                if ($referralUser) {

                    $referralName = $referralUser->name;

                }

            }

            $user = new User();

            $user->user_id = $UserID;

            $user->name = $request->name;

            $user->referral_id = $request->referral_id;

            $user->email = $request->email;

            $user->phone_number = $request->phone_number;

            $user->referral_name = $referralName;

            $user->password = Hash::make($request->password);

            $user->save();

            DB::commit();

            return redirect()->route('registration_success')->with('user', $user);

        } catch (\Exception $e) {

            DB::rollback();

            Log::error('Error while Registration:', ['error' => $e->getMessage()]);

            return redirect()->back()->with('error', 'An error occurred while processing.');

        }

    }

    public function forgot_password()

    {

        return view('admin.forgot_password');

    }

    public function add_bank()

    {

        $bankDetails = BankDetails::all();

        return view('admin.add_bank', compact('bankDetails'));

    }

    public function edit_bank($id)

    {

        $bank = BankDetails::findOrFail($id);

        return view('admin.edit_bank', compact('bank'));

    }

    public function bank_history()

    {

        return view('admin.bank_history');

    }

    public function create_password($email)

    {

        return view('admin.create_password', compact('email'));

    }

    public function user_create_password($email, $id)

    {

        return view('admin.user_create_password', compact('email', 'id'));

    }

    public function sucess_password()

    {

        return view('admin.sucess_password');

    }

    public function profile()

    {

        $user = auth()->user();

        Log::info($user);

        return view('admin.profile', compact('user'));

    }

    public function user_management()

    {

        $users = User::with(['addresses', 'incomeWallet'])->where('role', 'user')

            ->orderBy('created_at', 'desc')->get();

        $memberships = Membership::where('is_active', 1)->get();

        return view('admin.user_management', compact('users', 'memberships'));

    }

    public function delivery_fee()

    {

        $deliveries = DeliveryFeeMaster::all();

        return view('admin.delivery_fee', compact('deliveries'));

    }

    public function category()

    {

        $categories = Category::with('deliveryFeeMaster')->get();

        return view('admin.category', compact('categories'));

    }

    public function add_category()

    {

        $towns = DeliveryFeeMaster::all();

        $categories = Category::where('category_type', 1)->get();

        return view('admin.add_category', compact('towns', 'categories'));

    }

    public function add_product()

    {

        $startId = 1001;

        $existingIds = Product::where('product_id', '>=', $startId)

            ->orderBy('product_id', 'asc')

            ->pluck('product_id')

            ->toArray();

        $nextProductId = $startId;

        foreach ($existingIds as $id) {

            if ($id == $nextProductId) {

                $nextProductId++;

            } else if ($id > $nextProductId) {

                break;

            }

        }

        $branches = Branch::all();

        $categories = Category::all();

        $user = auth()->user();

        return view('admin.add_product', compact('categories', 'nextProductId', 'branches', 'user'));

    }

    public function view_product($id)

    {

        $product = Product::with(['variants'])->findOrFail($id);

        $categories = Category::all();

        $branches = Branch::all();

        return view('admin.view_product', compact('product', 'categories', 'branches'));

    }

    public function banner()

    {

        $banners = BannerImage::all();

        return view('admin.banner', compact('banners'));

    }

    public function reset_password()

    {

        return view('admin.reset_password');

    }

    public function notification()

    {

        $notifications = Notification::all();

        return view('admin.notification', compact('notifications'));

    }

    public function recent_orders()

    {

        $recent_orders = OrderDetails::with(['user.membershipRelation'])

            ->where('status', 'pending')

            ->orderBy('created_at', 'desc')

            ->get();

        $cancelledOrderCount = OrderDetails::where('status', 'rejected')->count();

        $acceptedOrderCount = OrderDetails::where('status', 'Accepted')->count();

        $recentOrderCount = OrderDetails::where('status', 'pending')->count();

        return view('admin.recent_orders', compact('recent_orders', 'acceptedOrderCount', 'recentOrderCount', 'cancelledOrderCount'));

    }

    public function accept_orders()

    {

        $recent_orders = OrderDetails::where('status', 'Accepted')->get();

        foreach ($recent_orders as $order) {

            $shiprocketcontroller = new ShiprocketController;

            $status = $shiprocketcontroller->getOrder_status($order->shiprocket_order_id);

            $order->status = $status;

        }

        return view('admin.accept_orders', compact('recent_orders'));

    }

    public function rejected_orders()

    {

        $recent_orders = OrderDetails::where('status', 'rejected')->get();

        return view('admin.rejected_orders', compact('recent_orders', ));

    }

    public function view_orders($id)

    {

        $user = User::with('addresses')->findOrFail($id);

        $userId = $user->user_id;

        $incomeWallet = IncomeWallet::where('user_id', $userId)->first();

        $referredUsers = User::with('membershipRelation')->where('referral_id', $userId)->get();

        $membership = Membership::where('membership_id', $user->membership)->first();

        $subscriptions = UserSubscription::where('user_id', $user->user_id)->orderBy('created_at', 'desc')->get();

        $joinDate = Carbon::parse($user->subscribed_at);

        if ($user->membership === 'MEMZ6965') {

            $expiryDate = $joinDate->copy()->addMonths(6);

        } else {

            $expiryDate = $joinDate->copy()->addYear();

        }

        $remainingDays = now()->lessThan($expiryDate)

            ? now()->diffInDays($expiryDate)

            : 0;

        return view(

            'admin.view_orders',

            compact(

                'user',

                'incomeWallet',

                'referredUsers',

                'membership',

                'subscriptions',

                'joinDate',

                'expiryDate',

                'remainingDays'

            )

        );

    }

    public function accepted_orders()

    {

        $recent_orders = OrderDetails::where('status', 'accepted')->orderBy('created_at', 'desc')

            ->get();

        return view('admin.accepted_orders', compact('recent_orders'));

    }

    public function shiprocket()

    {

        $recent_orders = OrderDetails::where('is_shipped', '1')->get();

        return view('admin.shiprocket', compact('recent_orders'));

    }

    public function processing_orders()

    {

        $couriers = Courier::all();

        $recent_orders = OrderDetails::where('status', 'shipped')->get();

        return view('admin.processing_orders', compact('recent_orders', 'couriers'));

    }

    public function delivered_orders()

    {

        $recent_orders = OrderDetails::where('status', 'delivered')->get();

        return view('admin.delivered_orders', compact('recent_orders'));

    }

    public function view_recent_orders($order_random_id)

    {

        $recent_orders = OrderDetails::with(['product', 'user.currentAddress'])

            ->where('order_random_id', $order_random_id)

            ->get();

        $acceptedOrderCount = OrderDetails::where('status', 'Accepted')->count();

        $recentOrderCount = OrderDetails::where('status', 'pending')->count();

        $cancelledOrderCount = OrderDetails::where('status', 'rejected')->count();

        $order = OrderDetails::where('order_random_id', $order_random_id)->first();

        $order_tracking = OrderTrack::where('order_id', $order_random_id)->get();

        $is_gst = User::where('role', 'admin')->where('is_gst', 1)->exists();

        $gst_rate = 18;

        return view('admin.view_recent_orders', compact(

            'recent_orders',

            'order',

            'is_gst',

            'gst_rate',

            'acceptedOrderCount',

            'recentOrderCount',

            'order_tracking',

            'cancelledOrderCount'

        ));

    }

    public function view_delivered_orders($order_random_id)

    {

        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)

            ->where('status', 'delivered')

            ->get();

        return view('admin.view_delivery_orders', compact('recent_orders'));

    }

    public function view_processing_orders($order_random_id)

    {

        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)

            ->where('status', 'shipped')

            ->get();

        return view('admin.view_processing_orders', compact('recent_orders'));

    }

    public function view_accepted_orders($order_random_id)

    {

        $recent_orders = OrderDetails::where('order_random_id', $order_random_id)

            ->where('status', 'accepted')

            ->get();

        return view('admin.view_accepted_orders', compact('recent_orders'));

    }

    public function cancelled_orders()

    {

        $cancelled_orders = OrderDetails::where('status', 'cancelled')->get();

        return view('admin.cancelled_order', compact('cancelled_orders'));

    }

    public function view_cancel_orders($order_random_id)

    {

        $cancelled_order = OrderDetails::where('order_random_id', $order_random_id)

            ->where('status', 'cancelled')

            ->get();

        return view('admin.view_cancel_orders', compact('cancelled_order'));

    }

    public function dashboard()

    {

        $userCount = User::where('role', 'user')->count();

        $acceptedOrderCount = OrderDetails::where('status', 'accepted')->count();

        $recentOrderCount = OrderDetails::where('status', 'pending')->count();

        $cancelledOrderCount = OrderDetails::where('status', 'rejected')->count();

        $totalMembership = User::whereNotNull('membership')->count();

        $basicCount = User::where('membership', 'MEMZ2462')->count();

        $proCount = User::where('membership', 'MEMZ002')->count();

        $primeCount = User::where('membership', 'MEMZ003')->count();

        $premiumCount = User::where('membership', 'MEMZ1392')->count();

        $eliteCount = User::where('membership', 'MEMZ9343')->count();

        $plusCount = User::where('membership', 'MEMZ001')->count();

        $trail_count = User::where('membership', 'MEMZ6965')->count();

        return view('admin.dashboard', compact(

            'userCount',

            'acceptedOrderCount',

            'recentOrderCount',

            'cancelledOrderCount',

            'totalMembership',

            'basicCount',

            'trail_count',

            'proCount',

            'primeCount',

            'premiumCount',

            'eliteCount',

            'plusCount'

        ));

    }

    public function referral_link()

    {

        $user = Auth::user();

        if ($user) {

            $userId = $user->user_id;

            $domain = URL::to('/');

            $url = $domain . '/register/' . $userId;

            return view('admin.referral_link', compact('url'));

        } else {

            return redirect()->route('login')->with('error', 'Please login!');

        }

    }

    public function register($user_id = "")

    {

        $referralId = $user_id;

        $userExists = User::where('user_id', $referralId)->exists();

        if (!$userExists) {

            return redirect()->route('referral_link')->with('error', 'Invalid Referral ID!');

        }

        Log::info("Referral ID: " . $referralId);

        return view('admin.register', compact('referralId'));

    }

    public function registration_success()

    {

        $user = session('user');

        return view('admin.registration_success', compact('user'));

    }

    public function add_user()

    {

        $memberships = Membership::where('is_active', 1)->get();

        $latestUser = User::where('user_id', 'LIKE', 'AD%')

            ->orderByDesc('user_id')

            ->first();

        if ($latestUser && preg_match('/AD(\d+)/', $latestUser->user_id, $matches)) {

            $nextNumber = intval($matches[1]) + 1;

        } else {

            $nextNumber = 2025;

        }

        do {

            $nextUserId = 'AD' . $nextNumber;

            $nextNumber++;

        } while (User::where('user_id', $nextUserId)->exists());

        return view('admin.add_user', compact('memberships', 'nextUserId'));

    }

    public function edit_user($id)

    {

        $user = User::findOrFail($id);

        $membership = Membership::where('membership_id', $user->membership)->first();

        $membershipTitle = $membership ? $membership->title : 'No Membership Found';

        $memberships = Membership::where('is_active', 1)->get();

        $address = Address::where('user_id', $user->id)->where('is_current', 1)->first();

        return view('admin.edit_user', compact('memberships', 'user', 'membershipTitle', 'address'));

    }

    public function edit_cashwallet($id)

    {

        $user = User::with('incomeWallet')->findOrFail($id);

        $datatable = EditWallet::where('user_id', $user->user_id)

            ->where('wallet', 'cash_wallet')

            ->orderBy('created_at', 'desc')

            ->get();

        return view('admin.edit_cashwallet', compact('user', 'datatable'));

    }

    public function edit_shoppingwallet($id)

    {

        $user = User::with('incomeWallet')->findOrFail($id);

        $datatable = EditWallet::where('user_id', $user->user_id)

            ->where('wallet', 'shopping_wallet')

            ->orderBy('created_at', 'desc')

            ->get();

        return view('admin.edit_shoppingwallet', compact('user', 'datatable'));

    }

    public function daily_task_history()

    {

        $datatables = Video::orderBy('created_at', 'desc')->get();

        return view('admin.daily_task_history', compact('datatables'));

    }

    public function edit_daily_task($id)

    {

        $datatables = Video::all();

        $video = Video::findOrFail($id);

        return view('admin.edit_daily_task', compact('datatables', 'video'));

    }

    public function create_plan_form()

    {

        return view('admin.create_plan');

    }

    public function create_plan_history()

    {

        $memberships = Membership::all();

        return view('admin.create_plan_history', compact('memberships'));

    }

    public function edit_plan($id)

    {

        $edit_plan = Membership::find($id);

        if (!$edit_plan) {

            return redirect()->route('membership_list')->with('error', 'Membership not found.');

        }

        return view('admin.edit_plan', compact('edit_plan'));

    }

    public function withdraw_request()

    {

        $withdrawRequests = WithdrawRequest::with(['user', 'bankDetails'])->get();

        $withdrawRequests->each(function ($request) {

            if ($request->type === 'bank' && $request->bankDetails) {

                $request->bank_account_holder_name = $request->bankDetails->account_holder_name;

                $request->bank_bank_name = $request->bankDetails->bank_name;

                $request->bank_account_number = $request->bankDetails->account_number;

                $request->bank_ifsc_code = $request->bankDetails->ifsc_code;

                $request->bank_branch = $request->bankDetails->branch;

                $request->derived_gpay_number = null;

            } elseif ($request->type === 'gpay') {

                $request->bank_account_holder_name = null;

                $request->bank_bank_name = null;

                $request->bank_account_number = null;

                $request->bank_ifsc_code = null;

                $request->bank_branch = null;

                $request->derived_gpay_number = $request->gpay_number;

            } else {

                $request->bank_account_holder_name = null;

                $request->bank_bank_name = null;

                $request->bank_account_number = null;

                $request->bank_ifsc_code = null;

                $request->bank_branch = null;

                $request->derived_gpay_number = null;

            }

        });

        return view('admin.withdraw_request', compact('withdrawRequests'));

    }

    public function accepted_withdraw()

    {

        $withdrawRequests = WithdrawRequest::where('status', 'accepted')->get();

        return view('admin.accept_withdraw', compact('withdrawRequests'));

    }

    public function rejected_withdraw()

    {

        $withdrawRequests = WithdrawRequest::where('status', 'rejected')->get();

        return view('admin.reject_withdraw', compact('withdrawRequests'));

    }

    public function orders_accept($order_random_id)

    {

        $orders = OrderDetails::where('order_random_id', $order_random_id)->get();

        if ($orders->isEmpty()) {

            return redirect()->back()->with('error', 'Order not found.');

        }

        foreach ($orders as $order) {

            $order->status = 'accepted';

            $order->save();

            OrderTrack::create([

                'user_id' => $order->user_id,

                'order_id' => $order->order_random_id,

                'remark' => 'Order has been accepted.',

                'status' => 'Accepted',

                'update_date' => now(),

            ]);

        }

        return redirect()->route('view_recent_orders', ['order_random_id' => $order_random_id])->with('success', 'Order accepted successfully.');

    }

    public function orders_reject($order_random_id)

    {

        $orders = OrderDetails::where('order_random_id', $order_random_id)->get();

        if ($orders->isEmpty()) {

            return redirect()->back()->with('error', 'Order not found.');

        }

        foreach ($orders as $order) {

            $order->status = 'rejected';

            $order->save();

            OrderTrack::create([

                'user_id' => $order->user_id,

                'order_id' => $order->order_random_id,

                'remark' => 'Order has been orders_reject.',

                'status' => 'rejected',

                'update_date' => now(),

            ]);

        }

        return redirect()->route('view_recent_orders', ['order_random_id' => $order_random_id])->with('success', 'Order accepted successfully.');

    }

    public function invoice($order_random_id)

    {

        $invoice = OrderDetails::with(['product', 'user.currentAddress'])

            ->where('order_random_id', $order_random_id)

            ->where('status', 'Accepted')

            ->first();

        if (!$invoice) {

            return redirect()->back()->with('error', 'Invoice not found.');

        }

        return view('admin.invoice', compact('invoice'));

    }

    public function view_category($id)

    {

        $categories = Category::all();

        $category = Category::findOrFail($id);

        return view('admin.view_category', compact('category', 'categories'));

    }

    public function contact_us()

    {

        $userRole = Auth::user()->role ?? 'unknown';

        $contacts = ContactUs::where('branch', $userRole)

            ->orderBy('id', 'desc')

            ->get();

        return view('admin.contact_us', compact('contacts'));

    }

    public function daily_transaction_history()

    {

        $acceptedSubscriptions = UserSubscription::where('status', 'accepted')

            ->with('user')

            ->get();

        $offlineSales = OfflineSale::with('user')

            ->latest()

            ->get()

            ->map(function ($transaction) {

                $transaction->type = 'Offline Sale';

                $transaction->amount = $transaction->amount_payable;

                $transaction->remark = 'Store_purchase - ' . $transaction->order_id;

                return $transaction;

            });

        $transactions = $acceptedSubscriptions

            ->concat($offlineSales)

            ->sortByDesc('created_at')

            ->values();

        return view('admin.daily_transaction_history', compact('transactions'));

    }

    public function pos_billing()

    {

        return view('admin.pos_billing');

    }

    public function offline_sales_history(Request $request)

    {

        $user = auth()->user();

        $branch = null;

        if ($user->role === 'sakthi') {

            $branch = 'Sakthi Super Mart';

        } elseif ($user->role === 'smart_world') {

            $branch = 'SMARTWORLD';

        } elseif ($user->role === 'chendur_traders') {

            $branch = 'CHENDUR TRADERS';

        } elseif ($user->role === 'yoga_naturals') {

            $branch = 'yoga naturals';

        }

        $offlineSales = OfflineSale::with('user')

            ->when($branch, function ($query) use ($branch) {

                return $query->where('branch', $branch);

            })

            ->when(!$request->from_date && !$request->to_date, function ($query) {

                return $query->whereMonth('created_at', now()->month)

                    ->whereYear('created_at', now()->year);

            })

            // ✅ Show any previous months when date filter applied

            ->when($request->from_date && $request->to_date, function ($query) use ($request) {

                return $query->whereBetween('created_at', [

                    $request->from_date . ' 00:00:00',

                    $request->to_date . ' 23:59:59'

                ]);

            })

            // ✅ Optional: search by phone number (backend support)

            ->when($request->phone, function ($query) use ($request) {

                $phone = preg_replace('/\D/', '', $request->phone);

                return $query->whereHas('user', function ($q) use ($phone) {

                    $q->where('phone_number', 'like', "%$phone%");

                });

            })

            ->latest()

            ->get();

        return view('admin.offline_sales_history', compact('offlineSales'));

    }

    public function cash_wallet_transaction()

    {

        $cashWalletTransactions = CashWalletIncome::with('user')

            ->orderBy('created_at', 'desc')

            ->get();

        return view('admin.cash_wallet_transaction', compact('cashWalletTransactions'));

    }

    public function shopping_wallet_transaction()

    {

        $shopWalletIncomes = shopWalletIncome::with('user')

            ->orderBy('created_at', 'desc')

            ->get();

        return view('admin.shoping_wallet_transaction', compact('shopWalletIncomes'));

    }

    public function add_logo()

    {

        $user = auth()->user();

        $userRole = $user->role ?? 'unknown';

        // ✅ If admin -> show all logos, else filter by branch

        $banners = Logo::query()

            ->when($userRole !== 'admin', function ($query) use ($userRole) {

                $query->where('branch', $userRole);

            })

            ->orderBy('id', 'desc')

            ->get();

        $branches = Branch::all();

        $employees = Employee::latest()

            ->when($user->role !== 'admin', function ($query) use ($user) {

                if ($user->role === 'sakthi') {

                    $query->where('branch', 'Sakthi Super Mart');

                } elseif ($user->role === 'smart_world') {

                    $query->where('branch', 'SMARTWORLD');

                } elseif ($user->role === 'smart_world_gift') {

                    $query->where('branch', 'SMARTWORLD - Stationary & Gifts');

                } elseif ($user->role === 'yoga_naturals') {

                    $query->where('branch', 'yoga naturals');

                }

            })

            ->get();

        return view('admin.add_logo', compact('banners', 'branches', 'employees'));

    }

    public function updateNote(Request $request)

    {

        $user = auth()->user();

        $user->is_note = filter_var($request->is_note, FILTER_VALIDATE_BOOLEAN) ? 1 : 0;

        if ($user->save()) {

            return response()->json(['success' => true]);

        }

        return response()->json(['success' => false]);

    }

    public function sakthi_dashboard()

    {

        return view('admin.sakthi_dashboard');

    }

    public function smartworld_dashboard()

    {

        return view('admin.smartworld_dashboard');

    }

    public function smartgift_dashboard()

    {

        return view('admin.smartgift_dashboard');

    }

    public function yoganaturals_dashboard()

    {

        return view('admin.yoganaturals_dashboard');

    }

    public function gstr2()

    {

        $user = auth()->user();

        // Map user role to branch

        $branch = null;

        if ($user->role === 'sakthi') {

            $branch = 'Sakthi Super Mart';

        } elseif ($user->role === 'smart_world') {

            $branch = 'SMARTWORLD';

        } elseif ($user->role === 'smart_world_gift') {

            $branch = 'SMARTWORLD - Stationary & Gifts';

        } elseif ($user->role === 'yoga_naturals') {

            $branch = 'yoga naturals';

        }

        // Filter purchases by branch

        $purchases = MyPurchase::with(['purchaseParty', 'items'])

            ->where('branch', $branch)

            ->get();

        return view('admin.gstr2', compact('purchases'));

    }

    // public function gstr1()

    // {

    //     $user = auth()->user();

    //     $branch = null;

    //     if ($user->role === 'sakthi') {

    //         $branch = 'Sakthi Super Mart';

    //     } elseif ($user->role === 'smart_world') {

    //         $branch = 'SMARTWORLD';

    //     } elseif ($user->role === 'smart_world_gift') {

    //         $branch = 'SMARTWORLD - Stationary & Gifts';

    //     } elseif ($user->role === 'yoga_naturals') {

    //         $branch = 'yoga naturals';

    //     }

    //     $sales = OfflineSale::where('branch', $branch)->get();

    //     return view('admin.gstr1', compact('sales'));

    // }

    public function gstr1()

    {

        $user = auth()->user();

        $branch = match ($user->role) {

            'sakthi' => 'Sakthi Super Mart',

            'smart_world' => 'SMARTWORLD',

            'smart_world_gift' => 'SMARTWORLD - Stationary & Gifts',

            'yoga_naturals' => 'yoga naturals',

            default => null,

        };

        $sales = OfflineSale::where('branch', $branch)

            ->orderByDesc('id')

            ->paginate(50);

        return view('admin.gstr1', compact('sales'));

    }

   

    // public function billWiseProfit(Request $request)

    // {

    //     $user = auth()->user();

    //     $branch = match ($user->role) {

    //         'sakthi' => 'Sakthi Super Mart',

    //         'smart_world' => 'SMARTWORLD',

    //         'chendur_traders' => 'CHENDUR TRADERS',

    //         'yoga_naturals' => 'yoga naturals',

    //         default => null

    //     };

    //     $query = OfflineSale::where('branch', $branch);

    //     if ($request->filled('from') && $request->filled('to')) {

    //         $from = $request->from . ' 00:00:00';

    //         $to = $request->to . ' 23:59:59';

    //         $query->whereBetween('created_at', [$from, $to]);

    //     } else {

    //         $query->whereMonth('created_at', now()->month)

    //             ->whereYear('created_at', now()->year);

    //     }

    //     $offlineSales = $query->latest()->get();

    //     foreach ($offlineSales as $sale) {

    //         $purchaseAmount = 0;

    //         $profit = 0;

    //         foreach ($sale->sale_items ?? [] as $item) {

    //             $qty = (float) ($item['quantity'] ?? 0);

    //             $purchase = (float) ($item['purchase_price'] ?? 0);

    //             $sell = (float) ($item['sell_price'] ?? 0);

    //             $purchaseAmount += $purchase * $qty;

    //             $profit += ($sell - $purchase) * $qty;

    //         }

    //         $profit -= ($sale->discount ?? 0);

    //         $profit += ($sale->additional_charge ?? 0);

    //         $profit -= ($sale->cash_wallet_deduction ?? 0);

    //         $profit -= ($sale->shopping_wallet_deduction ?? 0);

    //         $sale->purchase_amount = $purchaseAmount;

    //         $sale->netprofit = $profit;

    //     }

    //     return view('admin.bill_wise_profit', compact('offlineSales'));

    // }



    public function billWiseProfit(Request $request)

{

    $user = auth()->user();



    $branch = match ($user->role) {

        'sakthi' => 'Sakthi Super Mart',

        'smart_world' => 'SMARTWORLD',

        'chendur_traders' => 'CHENDUR TRADERS',

        'yoga_naturals' => 'yoga naturals',

        default => null

    };



    $query = OfflineSale::where('branch', $branch);



    if ($request->filled('from') && $request->filled('to')) {

        $query->whereBetween('created_at', [

            $request->from . ' 00:00:00',

            $request->to . ' 23:59:59'

        ]);

    } else {

        $query->whereMonth('created_at', now()->month)

              ->whereYear('created_at', now()->year);

    }



    $offlineSales = $query->latest()->get();



    foreach ($offlineSales as $sale) {

        $purchaseAmount = 0;

        $profit = 0;



        foreach ($sale->sale_items ?? [] as $item) {

            $qty = (float) ($item['quantity'] ?? 0);

            $sell = (float) ($item['sell_price'] ?? 0);



            // 🔥 FIX: fallback purchase price

            if (!isset($item['purchase_price']) || $item['purchase_price'] == 0) {

                $product = Product::where('item_code', $item['item_code'])->first();

                $purchase = (float) ($product->purchase_price ?? 0);

            } else {

                $purchase = (float) $item['purchase_price'];

            }



            $purchaseAmount += $purchase * $qty;

            $profit += ($sell - $purchase) * $qty;

        }



        // Adjustments

        $profit -= ($sale->discount ?? 0);

        $profit += ($sale->additional_charge ?? 0);

        $profit -= ($sale->cash_wallet_deduction ?? 0);

        $profit -= ($sale->shopping_wallet_deduction ?? 0);



        // Attach calculated values

        $sale->purchase_amount = $purchaseAmount;

        $sale->netprofit = $profit;

    }



    return view('admin.bill_wise_profit', compact('offlineSales'));

}







    public function purchase_invoices()

    {

        $user = auth()->user();

        $branch = null;

        if ($user->role === 'sakthi') {

            $branch = 'Sakthi Super Mart';

        } elseif ($user->role === 'smart_world') {

            $branch = 'SMARTWORLD';

        } elseif ($user->role === 'smart_world_gift') {

            $branch = 'SMARTWORLD - Stationary & Gifts';

        } elseif ($user->role === 'yoga_naturals') {

            $branch = 'yoga naturals';

        }

        $purchases = MyPurchase::with('purchaseParty')

            ->where('branch', $branch)

            ->latest()

            ->get();

        return view('admin.purchase_invoice', compact('purchases'));

    }

    public function invoice_create()

    {

        $parties = ProductPurchase::select('customer_name')->distinct()->get();

        return view('admin.purchase_bill', compact('parties'));

    }

    public function purchase_parties()

    {

        $user = auth()->user();

        $branch = null;

        if ($user->role === 'sakthi') {

            $branch = 'Sakthi Super Mart';

        } elseif ($user->role === 'smart_world') {

            $branch = 'SMARTWORLD';

        } elseif ($user->role === 'smart_world_gift') {

            $branch = 'SMARTWORLD - Stationary & Gifts';

        } elseif ($user->role === 'yoga_naturals') {

            $branch = 'yoga naturals';

        }

        $purchases = ProductPurchase::query()

            ->when($user->role !== 'admin', function ($query) use ($branch) {

                $query->where('branch', $branch);

            })

            ->get();

        return view('admin.purchase_parties', compact('purchases'));

    }

    public function edit_purchase($id)

    {

        $purchase = ProductPurchase::findOrFail($id);

        return view('admin.edit_purchase', compact('purchase'));

    }

}

