<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use SendinBlue\Client\Configuration;
use SendinBlue\Client\Api\TransactionalEmailsApi;
use GuzzleHttp\Client;
use Exception;
use Illuminate\Support\Facades\File;

class BrevoMailController extends Controller
{
    public function send()
    {
        $apiKey      = env('BREVO_API_KEY');
        $config      = Configuration::getDefaultConfiguration()->setApiKey('api-key', $apiKey);
        $apiInstance = new TransactionalEmailsApi(new Client(), $config);

        $sendSmtpEmail = new \SendinBlue\Client\Model\SendSmtpEmail([
            'subject'     => 'Test Email via Brevo API',
            'htmlContent' => '<strong>Hello from Laravel using Brevo API</strong>',
            'sender'      => ['name' => 'Adbazzar', 'email' => 'smartworld2025@gmail.com'],
            'to'          => [['email' => 'novelxansalna@gmail.com']],
        ]);

        try {
            $result = $apiInstance->sendTransacEmail($sendSmtpEmail);
            return response()->json([
                'message' => 'Email sent successfully via Brevo API!',
                'result'  => $result
            ]);
        } catch (Exception $e) {
            return response()->json([
                'message' => 'Failed to send email.',
                'error'   => $e->getMessage()
            ], 500);
        }
    }


public function rename_log()
{
    $logPath = storage_path('logs/laravel.log');

    if (!File::exists($logPath)) {
        return 'Log file does not exist.';
    }

    $date       = date('Y-m-d');
    $newLogPath = storage_path("logs/laravel-$date.log");

    if (File::move($logPath, $newLogPath)) {
        return "Log file renamed to laravel-$date.log";
    } else {
        return "Failed to rename log file.";
    }
}

}
