<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;
use App\Models\Employee;
use Illuminate\Support\Facades\Crypt;
use App\Mail\OtpMail;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use App\Models\Employee;
use App\Models\Product;


class LoginController extends Controller
{
       public function employee_logout(Request $request)
    {

        Auth::logout();
        $request->session()->flush();
        $request->session()->regenerateToken();
        return redirect()->route('employee.login');
    }



    public function employee_login_sendotp(Request $request)
    {
        try {
            $request->validate([
                'email' => 'required|email',
                'password' => 'required',
            ]);

            $Employee = Employee::where('email', $request->input('email'))->first();

            if (!$Employee || !Hash::check($request->input('password'), $Employee->password)) {
                return response()->json(['status' => 'error', 'message' => 'Invalid email or password']);
            }
            if (!$Employee) {
                return response()->json(['status' => 'error', 'message' => 'Employee not found']);
            }

            $otp = '123456';
            $Employee->otp = Crypt::encryptString($otp);
            $Employee->otp_expires_at = now()->addMinutes(1);
            $Employee->save();

            return response()->json(['status' => 'success', 'message' => 'OTP sent successfully']);

        } catch (\Exception $e) {
            return response()->json(['status' => 'error', 'message' => 'An error occurred while sending OTP. Please try again.']);
        }
    }

    public function employee_login_verifyotp(Request $request)
    {
        try {
            $request->validate([
                'email' => 'required|email',
                'otp' => 'required|numeric',
                'password' => 'required',
            ]);

            $Employee = Employee::where('email', $request->input('email'))->first();

            if (!$Employee || !Hash::check($request->input('password'), $Employee->password)) {
                return response()->json(['status' => 'error', 'message' => 'Invalid credentials']);
            }

            if (now()->greaterThan($Employee->otp_expires_at)) {
                return response()->json(['status' => 'error', 'message' => 'OTP has expired']);
            }

            $decryptedOtp = Crypt::decryptString($Employee->otp);
            if ($request->input('otp') != $decryptedOtp) {
                return response()->json(['status' => 'error', 'message' => 'Invalid OTP']);
            }

            $Employee->otp = null;
            $Employee->otp_expires_at = null;
            $Employee->save();

            Auth::login($Employee);


            if ($Employee->role === 'admin') {
                $redirectUrl = route('dashboard');
            } elseif ($Employee->role === 'sakthi') {
                $redirectUrl = route('dashboard');
            } elseif ($Employee->role === 'smart_world') {
                $redirectUrl = route('dashboard');
            } elseif ($Employee->role === 'smart_world_gift') {
                $redirectUrl = route('dashboard');
            } elseif ($Employee->role === 'yoga_naturals') {
                $redirectUrl = route('dashboard');
            } else {
                $redirectUrl = route('dashboard');
            }

            return response()->json(['status' => 'success', 'redirect_url' => $redirectUrl]);

        } catch (\Exception $e) {
            return response()->json(['status' => 'error', 'message' => 'An error occurred while verifying OTP. Please try again.']);
        }
    }








}
