<?php
namespace App\Http\Controllers\Profile;
use App\Http\Controllers\Controller;
use App\Mail\RegistrationSuccessMail;
use App\Models\Branch;
use App\Models\IncomeWallet;
use App\Models\Membership;
use App\Models\User;
use App\Models\UserSubscription;
use App\Models\shopWalletIncome;
use App\Models\Address;
use Carbon\Carbon;
use App\Models\CashWalletIncome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
class ProfileController extends Controller
{
      public function toggle_activation($id)
    {
        $user = User::findOrFail($id);
        $user->is_active = !$user->is_active;
        $user->save();
        return redirect()->back()->with('success', 'User status updated successfully!');
    }
 public function edit_update(Request $request, $id)
    {
        $user = User::findOrFail($id);
        $validator = Validator::make($request->all(), [
            'name'          => 'nullable|string|max:255',
            'password'      => 'nullable',
            'email'         => 'nullable|email|unique:users,email,' . $id,
            'address'       => 'nullable|string|max:255',
            'phone'         => 'nullable|digits_between:10,15',
            'membership_id' => 'nullable|exists:memberships,id',
            'payment_mode'   =>'nullable',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        // Fetch existing membership if any
        $membership = $user->membership
            ? Membership::find($user->membership)
            : null;
        // If admin has selected a new membership
        if ($request->filled('membership_id')) {
            $membership = Membership::find($request->membership_id);
            if (!$membership) {
                return redirect()->back()->with('error', 'Invalid Membership ID');
            }
            $user->membership     = $membership->membership_id;
            $user->is_subscribed  = 1;
        }
        // Update core user fields
        $user->name          = $request->name;
        $user->password      = Hash::make($request->password);
        $user->email         = $request->email;
        $user->phone_number  = $request->phone;
        $user->save();
        if ($membership && $request->filled('membership_id')) {
            try {
               $subscription                 = new UserSubscription();
               $subscription->user_id        = $user->user_id;
               $subscription->name           = $user->name;
               $subscription->membership_id  = $membership->membership_id;
               $subscription->title          = $membership->title;
               $subscription->amount         = $membership->amount;
               $subscription->days           = $membership->days;
               $subscription->transaction_id = null;
               $subscription->payment_mode   = $request->payment_mode;
               $subscription->status         = "Accepted";
               $subscription->remark         = "Admin updated";
               $subscription->action_at      = now();
               $subscription->is_active      = 1;
                $subscription->save();
                Log::info('Subscription added automatically:', ['subscription' => $subscription]);
                // 2) Update user's subscription dates
                 $user->subscribed_at = Carbon::now();

    
    if ($membership->membership_id === 'MEMZ6965') {
       
        $user->subscription_end_date = Carbon::now()->addMonths(6);
    } else {
      
        $user->subscription_end_date = Carbon::now()->addYear();
    }

    $user->save();
                // 3) Credit referral income to referrer, if any
                if (!empty($user->referral_id)) {
                    Log::info('Processing referral income for admin-updated subscription.', ['user_id' => $user->user_id]);
                    $this->referral_income($user->user_id, $membership->id ,$request->payment_mode);
                }
                // 4) Credit welcome bonus to user
                if (!is_null($membership->welcome_bonus) && $membership->welcome_bonus > 0) {
                    Log::info('Processing welcome income for admin-updated subscription.', ['user_id' => $user->user_id]);
                    $this->welcome_income($user->user_id, $membership->id);
                }
            } catch (\Exception $e) {
                Log::error('Exception Error in auto-subscription: ' . $e->getMessage());
            }
        }
        return redirect()->route('edit_user', $id)
                         ->with('success', 'User details updated successfully!');
    }
    public function referral_income($user_id, $membership_id,$payment_mode)
    {
        try {
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::error("User not found with user_id: {$user_id}");
                return false;
            }
            $membership = Membership::find($membership_id);
            if (!$membership) {
                Log::error("Membership not found: {$membership_id}");
                return false;
            }
            $reward = $membership->amount * $membership->referral_percentage / 100;
         $referralIncome                = new CashWalletIncome();
         $referralIncome->user_id       = $user->referral_id;
         $referralIncome->membership_id = $membership->membership_id;
         $referralIncome->amount        = $reward;
         $referralIncome->remark        = "Referral Income";
         $referralIncome->description   = $user_id;
         $referralIncome->payment_mode  = $payment_mode;
         $referralIncome->type          = "referral";
            $referralIncome->save();
            Log::info("Referral income added for user_id: {$user_id}, amount: {$reward}");
            $income_wallet = IncomeWallet::firstWhere('user_id', $user->referral_id);
            if ($income_wallet) {
                $income_wallet->referral_income += $reward;
                $income_wallet->cash_wallet     += $reward;
                $income_wallet->save();
                Log::info("Updated referral income wallet for referral user_id: {$user->referral_id}, new amount: {$income_wallet->referral_income}");
            } else {
                $wallet = new IncomeWallet();
                $wallet->user_id         = $user->referral_id;            
                $wallet->referral_income = $reward;
                $wallet->cash_wallet     = $reward;
                $wallet->save();
                Log::info("Created new income wallet for referral user_id: {$user->referral_id} with amount: {$reward}");
            }
            return true;
        } catch (\Exception $e) {
            Log::error("Exception in referral_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace'   => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
    public function welcome_income($user_id, $membership_id)
    {
        try {
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::info("User not found with user_id: {$user_id}");
                return false;
            }
            $membership = Membership::find($membership_id);
            if (!$membership) {
                Log::info("Membership not found: {$membership_id}");
                return false;
            }
            $welcome_bonus = $membership->welcome_bonus;
            // Record in ShopWalletIncome (or whichever model)
            $welcomeIncome = new shopWalletIncome();
            $welcomeIncome->user_id       = $user_id;
            $welcomeIncome->membership_id = $membership->membership_id;
            $welcomeIncome->amount        = $welcome_bonus;
            $welcomeIncome->remark        = "Welcome Income";
            $welcomeIncome->type          = "credit";
            $welcomeIncome->save();
            Log::info("Welcome income added for user_id: {$user_id}, amount: {$welcome_bonus}");
            // Update or create user's IncomeWallet
            $income_wallet = IncomeWallet::firstWhere('user_id', $user_id);
            if ($income_wallet) {
                $income_wallet->welcome_income  += $welcome_bonus;
                $income_wallet->shopping_wallet += $welcome_bonus;
                $income_wallet->save();
                Log::info("Updated income wallet for user_id: {$user_id}, new welcome income: {$income_wallet->welcome_income}");
            } else {
                $wallet = new IncomeWallet();
                $wallet->user_id        = $user_id;
                $wallet->welcome_income = $welcome_bonus;
                $wallet->shopping_wallet= $welcome_bonus;
                $wallet->save();
                Log::info("Created new income wallet for user_id: {$user_id} with welcome income: {$welcome_bonus}");
            }
            return true;
        } catch (\Exception $e) {
            Log::info("Exception in welcome_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace'   => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
    public function branch_post(Request $request)
    {
        $request->validate([
            'branch_name' => 'required|string|max:255',
        ]);
        Branch::create([
            'branch_name' => $request->branch_name,
        ]);
        return back()->with('success', 'Branch created successfully!');
    }
public function branch_delete($id)
{
    $branch = Branch::findOrFail($id);
    $branch->delete();
    return back()->with('success', 'Branch deleted successfully!');
}
}
