<?php

namespace App\Http\Controllers\Profile;

use App\Http\Controllers\Controller;
use App\Traits\ShiprocketTrait;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

use Shiprocket;

class ShiprocketController extends Controller
{

    public function shiprocket_get_token()
    {
        try {
            $response = Http::post('https://apiv2.shiprocket.in/v1/external/auth/login', [
                'email'    => 'sterbin001@gmail.com',
                'password' => 'Sterbin#021',
            ]);

            $jsonData = $response->json();

            if (isset($jsonData['token'])) {
                Log::info("Shiprocket Token Generated Successfully");
                return $jsonData['token'];
            } else {
                Log::info("Failed to get Shiprocket token", $jsonData);
                return null;
            }
        } catch (\Throwable $th) {
            Log::info("Shiprocket Token Error: " . $th->getMessage());
            return null;
        }
    }

    public function api($method, $urls, $data = null)
    {
        try {
            $url = "https://apiv2.shiprocket.in/v1/external/" . $urls;

            $token = self::shiprocket_get_token();

            if (!$token) {
                Log::info("Token retrieval failed. Cannot make API request.");
                return (object)[
                    'status' => 'error',
                    'message' => 'Failed to retrieve token'
                ];
            }

            $headers = [
                'Content-Type'  => 'application/json',
                'Authorization' => 'Bearer ' . $token
            ];

            Log::info("Shiprocket API Request", [
                'method'  => strtoupper($method),
                'url'     => $url,
                'payload' => $data
            ]);

            $response = strtolower($method) === "post"
                ? Http::withHeaders($headers)->post($url, $data)
                : Http::withHeaders($headers)->get($url, $data);

            Log::info("Shiprocket API Response", [
                'status' => $response->status(),
                'body'   => $response->json()
            ]);

            if ($response->successful()) {
                return (object)[
                    'status' => 'success',
                    'data'   => $response->json()
                ];
            } else {
                Log::info("API request failed", [
                    'status' => $response->status(),
                    'message'  => $response->json()
                ]);
                return (object)[
                    'status' => 'error',
                    'message' => $response->json(),
                ];
            }
        } catch (\Throwable $th) {
            Log::info("Shiprocket API Error", [
                'message' => $th->getMessage(),
                'trace'   => $th->getTraceAsString()
            ]);
            return (object)[
                'status'  => 'error',
                'message' => $th->getMessage()
            ];
        }
    }

    public function shiprocket_create_orders()
    {
        $data = [
            'order_id'              => 'ODR12d3',
            'order_date'            => now()->format('Y-m-d'),
            'pickup_location'       => 'Primary',
            'billing_customer_name' => 'test5',
            'billing_last_name'     => 'test5',
            'billing_address'       => 'awesrtfg3f3',
            'billing_city'          => 'tes3ft',
            'billing_pincode'       => '110001',
            'billing_state'         => 'Delhi',
            'billing_country'       => 'India',
            'billing_email'         => 'fffff@gmail.com',
            'billing_phone'         => '9089786754',
            'shipping_is_billing'   => true,
            'order_items'           => [
                [
                    'name'          => 'frewewf',
                    'sku'           => 'chakra123',
                    'units'         => 1,
                    'selling_price' => 200,
                    'discount'      => '',
                    'tax'           => '',
                    'hsn'           => '',
                ],
                [
                    'name'          => 'sterff',
                    'sku'           => 'zakded123',
                    'units'         => 1,
                    'selling_price' => 200,
                    'discount'      => '',
                    'tax'           => '',
                    'hsn'           => '',
                ],
            ],
            "payment_method"      => "Prepaid",
            "shipping_charges"    => 0,
            "giftwrap_charges"    => 0,
            "transaction_charges" => 0,
            "total_discount"      => 0,
            "sub_total"           => 9000,
            "length"              => 10,
            "breadth"             => 15,
            "height"              => 20,
            "weight"              => 2.5
        ];

        $response = self::api('post', 'orders/create/adhoc', $data);

        return $response;
    }

    public function getOrders()
    {
        try {
            $response = $this->api('get', 'orders', null);

            if (isset($response->status) && $response->status == 'success') {
                $data = $response->data ?? null;

                if (!isset($data['data']) || !is_array($data['data'])) {
                    return "Invalid response structure";
                }

                $orders = [];

                foreach ($data['data'] as $order) {

                    $shipment = $order['shipments'] ?? [];

                    $shipment_id = '';
                    if (is_array($shipment)) {
                        if (isset($shipment[0]['id'])) {
                            $shipment_id   = $shipment[0]['id'];
                            $shipment_data = $shipment[0];
                        } else {
                            $shipment_data = $shipment;
                            $shipment_id   = $shipment['id'] ?? '';
                        }
                    } else {
                        $shipment_data = (array) $shipment;
                        $shipment_id   = $shipment_data['id'] ?? '';
                    }

                    $orders[] = [
                        'id'             => $order['id'] ?? '',
                        'shipment_id'    => $shipment_id,
                        'order_id'       => $order['channel_order_id'] ?? '',
                        'customer_name'  => $order['customer_name'] ?? '',
                        'email'          => $order['customer_email'] ?? '',
                        'phone'          => $order['customer_phone'] ?? '',
                        'address'        => trim(($order['customer_address'] ?? '') . ' ' . ($order['customer_address_2'] ?? '')),
                        'city'           => $order['customer_city'] ?? '',
                        'state'          => $order['customer_state'] ?? '',
                        'pincode'        => $order['customer_pincode'] ?? '',
                        'country'        => $order['customer_country'] ?? '',
                        'payment_method' => $order['payment_method'] ?? '',
                        'total_amount'   => $order['total'] ?? 0,
                        'items'          => array_map(function ($item) {
                            return [
                                'name'          => $item['name'] ?? '',
                                'sku'           => $item['channel_sku'] ?? '',
                                'quantity'      => $item['quantity'] ?? 0,
                                'price'         => $item['price'] ?? 0,
                                'selling_price' => $item['selling_price'] ?? 0,
                                'discount'      => $item['discount'] ?? 0,
                                'hsn'           => $item['hsn'] ?? '',
                            ];
                        }, $order['products'] ?? []),
                        'dimensions'      => $shipment_data['dimensions'] ?? '',
                        'weight'          => $shipment_data['weight'] ?? '',
                        'pickup_location' => $order['pickup_location'] ?? '',
                        'created_at'      => $order['created_at'] ?? '',
                        'status'          => $order['status'] ?? '',
                    ];
                }

                return $orders;
            } else {
                Log::info("API request failed in getOrders", [
                    'status' => $response->status ?? 'unknown',
                    'error'  => $response->error ?? 'No error info',
                    'message' => $response->message ?? ''
                ]);
                return "Failed to fetch orders.";
            }
        } catch (\Throwable $th) {
            Log::info('Error in fetching Orders.', [
                'message' => $th->getMessage(),
                'trace'   => $th->getTraceAsString()
            ]);
            return 'exception error';
        }
    }

    public function getOrder_status($id)
    {
        try {
            $response = self::api('get', "orders/show/$id", null);
            $data     = json_decode(json_encode($response), true);

            return $data['data']['data']['status'] ?? 'Status not found';
        } catch (\Throwable $th) {
            Log::info('Error in fetching Order.', [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString()
            ]);
            return 'exception error';
        }
    }



    public function getSingleOrder($id)
    {
        try {
            $response = self::api('get', "orders/show/$id", null);

            $data = json_decode(json_encode($response), true);
            if (!isset($data['data'])) {
                return "Invalid response structure";
            }

            $order       = $data['data'];

            return [
                'id'             => $order['id'] ?? '',
                'shipment_id'    => $order['shipments']['id'] ?? '',
                'order_id'       => $order['channel_order_id'] ?? '',
                'customer_name'  => $order['customer_name'] ?? '',
                'email'          => $order['customer_email'] ?? '',
                'phone'          => $order['customer_phone'] ?? '',
                'address'        => trim(($order['customer_address'] ?? '') . ' ' . ($order['customer_address_2'] ?? '')),
                'city'           => $order['customer_city'] ?? '',
                'state'          => $order['customer_state'] ?? '',
                'pincode'        => $order['customer_pincode'] ?? '',
                'country'        => $order['customer_country'] ?? '',
                'payment_method' => $order['payment_method'] ?? '',
                'total_amount'   => $order['total'] ?? 0,
                'items'          => array_map(function ($item) {
                    return [
                        'name'          => $item['name'] ?? '',
                        'sku'           => $item['channel_sku'] ?? '',
                        'quantity'      => $item['quantity'] ?? 0,
                        'price'         => $item['price'] ?? 0,
                        'selling_price' => $item['selling_price'] ?? 0,
                        'discount'      => $item['discount'] ?? 0,
                        'hsn'           => $item['hsn'] ?? '',
                    ];
                }, $order['products'] ?? []),
                'dimensions'      => $order['shipments'][0]['dimensions'] ?? '',
                'weight'          => $order['shipments'][0]['weight'] ?? '',
                'pickup_location' => $order['pickup_location'] ?? '',
                'created_at'      => $order['created_at'] ?? '',
                'status'          => $order['status'] ?? '',
            ];
        } catch (\Throwable $th) {
            Log::info('Error in fetching Order.', [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString()
            ]);
            return 'exception error';
        }
    }

    public function cancelOrders()
    {
        try {
            $data = ['ids' => ['833562622']];

            $response = self::api('post', "orders/cancel", $data);

            return $response;
        } catch (\Throwable $th) {
            Log::info('Error in canceling Order.', [
                'message' => $th->getMessage(),
                'trace'   => $th->getTraceAsString()
            ]);
            return 'exception error';
        }
    }


    public function getPickupLocations()
    {
        try {
            $response = self::api('get', 'settings/company/pickup', null);


            return $response;
        } catch (\Throwable $th) {
            Log::info('Error in fetching Pickup Locations.', [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString()
            ]);

            return 'exception error';
        }
    }


    public function getCourierPartners($orderId)
    {
        try {
            $response = $this->api('get', "courier/serviceability/?order_id={$orderId}", null);

            if (isset($response->status) && $response->status == 'success') {
                $data = $response->data ?? null;

                if (empty($data['data']['available_courier_companies'])) {
                    return "No courier partners found.";
                }

                $couriers = array_map(function ($courier) {
                    return [
                        'courier_company_id'      => $courier['courier_company_id'] ?? '',
                        'courier_name'            => $courier['courier_name'] ?? '',
                        'freight_charge'          => $courier['freight_charge'] ?? 0,
                        'cod'                     => $courier['cod'] ?? 0,
                        'cod_charges'             => $courier['cod_charges'] ?? 0,
                        'estimated_delivery_days' => $courier['estimated_delivery_days'] ?? '',
                        'etd'                     => $courier['etd'] ?? '',
                        'delivery_performance'    => $courier['delivery_performance'] ?? '',
                        'pickup_performance'      => $courier['pickup_performance'] ?? '',
                        'realtime_tracking'       => $courier['realtime_tracking'] ?? '',
                    ];
                }, $data['data']['available_courier_companies']);

                return $couriers;
            } else {
                Log::error("API request failed", [
                    'status' => $response->status ?? 'unknown',
                    'error'  => $response->error ?? 'No error info',
                    'message' => $response->message ?? ''
                ]);

                return (object)[
                    'status'  => $response->status ?? 0,
                    'message' => 'Request failed',
                    'error'   => $response->error ?? []
                ];
            }
        } catch (\Throwable $th) {
            Log::error('Error in fetching available couriers.', [
                'message' => $th->getMessage(),
                'trace'   => $th->getTraceAsString()
            ]);
            return 'exception error';
        }
    }

    public function assignShip($shipmentId, $courierId = null)
    {
        try {
            $payload = [
                'shipment_id' => $shipmentId,
            ];

            if ($courierId) {
                $payload['courier_id'] = $courierId;
            }

            $response = $this->api('post', 'courier/assign/awb', $payload);

            return $response;
        } catch (\Throwable $th) {
            Log::info('Error assigning AWB', [
                'message' => $th->getMessage()
            ]);
            return 'AWB assignment failed.';
        }
    }




    // public function assignShip($shipmentId, $courierId = null)
    // {
    //     try {

    //         $payload = [
    //             'shipment_id' => $shipmentId,
    //             'courier_id'  => $courierId,
    //         ];

    //         $response = self::api('post', 'courier/assign/awb', $payload);

    //         if (isset($response->status) && $response->status >= 200 && $response->status < 300) {
    //             return $response->data ?? [];
    //         } else {
    //             Log::error('Failed to assign AWB', [
    //                 'status'  => $response->status ?? 'unknown',
    //                 'message' => $response->message ?? 'Unknown error',
    //                 'error'   => $response->error ?? []
    //             ]);

    //             return (object)[
    //                 'status'  => $response->status ?? 0,
    //                 'message' => $response->message ?? 'AWB assignment failed.',
    //                 'error'   => $response->error ?? []
    //             ];
    //         }
    //     } catch (\Throwable $th) {
    //         Log::error('Error assigning AWB', [
    //             'message' => $th->getMessage(),
    //             'trace'   => $th->getTraceAsString()
    //         ]);
    //         return 'AWB assignment failed.';
    //     }
    // }


    public function schedulePickup($shipmentId)
    {
        try {
            $payload = [
                'shipment_id' => $shipmentId,
            ];

            $response = self::api('post', 'courier/generate/pickup', $payload);

            return $response;
        } catch (\Throwable $th) {
            Log::error('Error scheduling pickup', [
                'message' => $th->getMessage()
            ]);
            return 'Pickup scheduling failed.';
        }
    }

    public function generateLabel($shipmentId)
    {
        try {
            $payload = [
                'shipment_id' => $shipmentId,
            ];

            $response = self::api('post', 'courier/generate/label', $payload);

            return $response; // contains PDF URL of label
        } catch (\Throwable $th) {
            Log::error('Error generating label', [
                'message' => $th->getMessage()
            ]);
            return 'Label generation failed.';
        }
    }
}
