<?php
namespace App\Http\Controllers\Subscription;
use App\Http\Controllers\Controller;
use App\Models\BankDetails;
use App\Models\EditWallet;
use Illuminate\Http\Request;
use App\Models\Membership;
use App\Models\User;
use App\Models\UserSubscription;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\shopWalletIncome;
use App\Models\IncomeWallet;
use App\Models\CashWalletIncome;
use Carbon\Carbon;
class SubscriptionController extends Controller
{
    public function membership_list()
{
    $membership_list = Membership::all();
    if ($membership_list->isNotEmpty()) {
        // Append full image URL
        $membership_list->transform(function ($membership) {
            $membership->image = $membership->image ? asset($membership->image) : null;
            return $membership;
        });
        return response()->json([
            'status' => 'success',
            'message' => 'Member List',
            'data' => $membership_list,
            'code' => 200,
        ], 200);
    } else {
        return response()->json([
            'status' => 'error',
            'message' => 'No data Found!',
            'data' => [],
            'code' => 401,
        ], 401);
    }
}
    public function add_subscription(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'user_id'        => 'required|exists:users,user_id',
                'membership_id'  => 'required|exists:memberships,membership_id',
                'transaction_id' => 'required|unique:user_subscriptions,transaction_id',
                'payment_image'  => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
            ]);
            if ($validator->fails()) {
                Log::error('Validation errors:', $validator->errors()->toArray());
                return response()->json([
                    'status'  => 'error',
                    'message' => 'Validation errors',
                    'code'    => 422,
                    'data'    => $validator->errors()
                ], 422);
            }
            $userdetails = User::where('user_id', $request->user_id)->first();
            $membership = Membership::where('membership_id', $request->membership_id)->first();
            $imagepath = null;
            if ($request->hasFile('payment_image')) {
                $payment_image     = $request->file('payment_image');
                $payment_imagename = time() . '_' . $payment_image->getClientOriginalName();
                $payment_image->move(public_path('assets/images/payment_images'), $payment_imagename);
                $imagepath = 'assets/images/payment_images/' . $payment_imagename;
            }
            $userdetails->subscribed_at         = Carbon::now();
            $userdetails->subscription_end_date = Carbon::now()->addYear();
            $userdetails->save();
            $data                 = new UserSubscription();
            $data->user_id        = $request->user_id;
            $data->name           = $userdetails->name;
            $data->membership_id  = $membership->membership_id;
            $data->title          = $membership->title;
            $data->amount         = $membership->amount;
            $data->days           = $membership->days;
            $data->transaction_id = $request->transaction_id;
            $data->payment_image  = $imagepath;
            $data->payment_mode  = 'upi';
            $data->status         = "Requested";
            $data->remark         = "Subscripiton Requested";
            $data->save();
            return response()->json([
                'status'  => 'success',
                'message' => 'Subscription added successfully',
                'data'    => $data,
                'code'    => 200,
            ], 200);
        } catch (\Exception $e) {
            Log::error('Exception Error in add_subscription: ' . $e->getMessage());
            return response()->json([
                'status'  => 'error',
                'message' => 'Exception Error',
                'code'    => 500,
                'data'    => 'Something went wrong! Please try again.'
            ], 500);
        }
    }
    public function subscription_requests()
    {
        $datatables = UserSubscription::where('status', 'Requested')->get();
        return view('admin.subscription_requests', compact('datatables'));
    }
    public function accept_request(Request $request)
    {
        try {
            Log::info('Accept Request initiated.', ['accept_id' => $request->accept_id]);
            $subscription = UserSubscription::find($request->accept_id);
            if (!$subscription) {
                Log::warning('Subscription not found.', ['accept_id' => $request->accept_id]);
                return redirect()->route('subscription_requests')->with('errormessage', "Subscription not found!");
            }
            Log::info('Subscription found.', ['subscription_id' => $subscription->id, 'user_id' => $subscription->user_id]);
            $subscription->status    = "Accepted";
            $subscription->remark    = "Subscription Accepted";
            $subscription->action_at = now();
            $subscription->is_active = 1;
            $subscription->save();
            $user = User::where('user_id', $subscription->user_id)->first();
            if (!$user) {
                Log::warning('User not found.', ['user_id' => $subscription->user_id]);
                return redirect()->route('subscription_requests')->with('errormessage', "User not found!");
            }
            Log::info('User found.', ['user_id' => $user->id]);
            if (!empty($user->referral_id)) {
                Log::info('Processing referral income.', ['user_id' => $user->user_id]);
                $this->referral_income($user->user_id, $subscription->membership_id);
            }
            $membership = Membership::where('membership_id', $subscription->membership_id)->first();
            if ($membership->welcome_bonus > 0) {
                Log::info('Processing welcome income.', ['user_id' => $user->user_id]);
                $this->welcome_income($user->user_id, $subscription->membership_id);
            }
            $user->membership    = $subscription->membership_id;
            $user->is_subscribed = 1;
            $user->save();
            Log::info('User subscription updated.', ['user_id' => $user->user_id]);
            return redirect()->route('subscription_requests')->with('successmessage', "Subscription accepted successfully!");
        } catch (\Exception $e) {
            Log::error('Exception Error in accept_request:', [
                'error_message' => $e->getMessage(),
                'stack_trace' => $e->getTraceAsString(),
            ]);
            return redirect()->route('subscription_requests')->with('errormessage', "Exception Error: " . $e->getMessage());
        }
    }
    public function referral_income($user_id, $membership_id)
    {
        try {
            // Fetch User
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::error("User not found with user_id: {$user_id}");
                return false;
            }
            // Fetch Membership
            $membership = Membership::where('membership_id', $membership_id)->first();
            if (!$membership) {
                Log::error("Membership not found with membership_id: {$membership_id}");
                return false;
            }
            // Calculate Reward
            $reward = $membership->amount * $membership->referral_percentage / 100;
            // Save Referral Income
            $referralIncome                = new CashWalletIncome();
            $referralIncome->user_id       = $user->referral_id;
            $referralIncome->membership_id = $membership_id;
            $referralIncome->amount        = $reward;
            $referralIncome->remark        = "Referral Income";
            $referralIncome->description   = $user_id;
            $referralIncome->type          = "credit";
            $referralIncome->save();
            Log::info("Referral income added for user_id: {$user_id}, amount: {$reward}");
            $income_wallet = IncomeWallet::where('user_id', $user->referral_id)->first();
            if ($income_wallet) {
                $income_wallet->referral_income += $reward;
                $income_wallet->cash_wallet     += $reward;
                $income_wallet->save();
                Log::info("Updated referral income wallet for user_id: {$user_id}, new amount: {$income_wallet->referral_income}");
            } else {
                $wallet                  = new IncomeWallet();
                $wallet->user_id         = $user_id;
                $wallet->referral_income = $reward;
                $wallet->cash_wallet     = $reward;
                $wallet->save();
                Log::info("Created new incoFme wallet for user_id: {$user_id} with amount: {$reward}");
            }
            return true;
        } catch (\Exception $e) {
            Log::error("Exception in referral_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace' => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
    public function welcome_income($user_id, $membership_id)
    {
        try {
            Log::info("welcome_income started");
            // Fetch User
            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::info("User not found with user_id: {$user_id}");
                return false;
            }
            Log::info("welcome_income startedcccccccccccccccccccccccc");
            // Fetch Membership
            $membership = Membership::where('membership_id', $membership_id)->first();
            if (!$membership) {
                Log::info("Membership not found with membership_id: {$membership_id}");
                return false;
            }
            Log::info("welcome_income startedxxxxxxxxxxxxxxxxxxxx");
            // Add Welcome Income
            $welcome_bonus                = $membership->welcome_bonus;
            $welcomeIncome                = new shopWalletIncome();
            $welcomeIncome->user_id       = $user_id;
            $welcomeIncome->membership_id = $membership->membership_id;
            $welcomeIncome->amount        = $welcome_bonus;
            $welcomeIncome->remark        = "Welcome Income";
            $welcomeIncome->type          = "credit";
            $welcomeIncome->save();
            Log::info("Welcome income added for user_id: {$user_id}, amount: {$welcome_bonus}");
            // Update or Create Income Wallet
            $income_wallet = IncomeWallet::where('user_id', $user_id)->first();
            if ($income_wallet) {
                $income_wallet->welcome_income  += $welcome_bonus;
                $income_wallet->shopping_wallet += $welcome_bonus;
                $income_wallet->save();
                Log::info("Updated income wallet for user_id: {$user_id}, new welcome income: {$income_wallet->welcome_income}");
            } else {
                // Create new Income Wallet
                $wallet                  = new IncomeWallet();
                $wallet->user_id         = $user_id;
                $wallet->welcome_income  = $welcome_bonus;
                $wallet->shopping_wallet = $welcome_bonus;
                $wallet->save();
                Log::info("Created new income wallet for user_id: {$user_id} with welcome income: {$welcome_bonus}");
            }
            return true;
        } catch (\Exception $e) {
            Log::info("Exception in welcome_income: " . $e->getMessage(), [
                'user_id' => $user_id,
                'trace'   => $e->getTraceAsString(),
            ]);
            return false;
        }
    }
    public function reject_request(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'remark' => 'required',
            ]);
            if ($validator->fails()) {
                return redirect()->back()->with('errormessage', $validator->errors()->first());
            }
            $subscription = UserSubscription::find($request->reject_id);
            if ($subscription) {
                $subscription->status    = "Rejected";
                $subscription->remark    = $request->remark;
                $subscription->action_at = now();
                $subscription->save();
                return redirect()->route('subscription_requests')->with('successmessage', "Subscription deleted successfully!");
            } else {
                return redirect()->route('subscription_requests')->with('errormessage', "Subscription not Found!");
            }
        } catch (\Exception $e) {
            return redirect()->route('subscription_requests')->with('errormessage', "Exception Error: " . $e->getMessage());
        }
    }
    public function bank_details()
    {
        $bank = BankDetails::where('type', 'admin')
                           ->where('is_active', 1)
                           ->first();
        if (!$bank) {
            return response()->json([
                'status'  => 'error',
                'message' => 'No data found!',
                'code'    => 404,
            ], 404);
        }
        $formattedData = [
            'user_id'             => $bank->user_id,
            'account_holder_name' => $bank->account_holder_name,
            'ifsc_code'           => $bank->ifsc_code,
            'account_number'      => $bank->account_number,
            'branch'              => $bank->branch,
            'bank_name'           => $bank->bank_name,
            'type'                => $bank->type,
            'is_active'           => $bank->is_active,
            'upi_id'              => $bank->upi_id,
            'image'               => $bank->image ? url(ltrim($bank->image, '/')) : null,
        ];
        return response()->json([
            'status'  => 'success',
            'message' => 'Bank details retrieved successfully',
            'data'    => $formattedData,
            'code'    => 200,
        ]);
    }
    public function income_wallet()
    {
        $incomewallet = IncomeWallet::where('user_id', Auth::user()->user_id)->first();
        if ($incomewallet) {
            return response()->json([
                'status'  => 'success',
                'message' => 'Income Wallet',
                'data'    => $incomewallet,
                'code'    => 200,
            ], 200);
        } else {
            return response()->json([
                'status'  => 'error',
                'message' => 'No data Found!',
                'data'    => [],
                'code'    => 401,
            ], 401);
        }
    }
    public function cashwallet_update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'type'            => 'required|in:credit,debit',
            'amount'          => 'required|numeric|min:1',
            'remark'          => 'required|string',
            'old_cash_wallet' => 'required|numeric|min:0',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $user   = User::findOrFail($id);
        $wallet = IncomeWallet::where('user_id', $user->user_id)->first();
        // If user has no wallet, create one
        if (!$wallet) {
            $wallet              = new IncomeWallet();
            $wallet->user_id     = $user->user_id;
            $wallet->cash_wallet = 0;
        }
        $oldCashWallet = $request->old_cash_wallet;
        $amount        = $request->amount;
        $type          = $request->type;
        if ($wallet->cash_wallet != $oldCashWallet) {
            return back()->with('error', 'Wallet balance has changed, please try again!');
        }
        if ($type == 'credit') {
            $wallet->cash_wallet += $amount;
        } elseif ($type == 'debit') {
            if ($wallet->cash_wallet < $amount) {
                return back()->with('error', 'Insufficient balance in cash wallet!');
            }
            $wallet->cash_wallet -= $amount;
        }
        $wallet->save();
        EditWallet::create([
            'user_id' => $user->user_id,
            'type'    => $type,
            'wallet'  => 'cash_wallet',
            'amount'  => $amount,
            'remark'  => $request->remark,
        ]);
         CashWalletIncome::create([
        'user_id'       => $user->user_id,
        'membership_id' => null, 
        'amount'        => $amount,
        'remark'        => $request->remark,
        'type'          => $type,
        'description'   => 'Manual ' . $type . ' by admin',
        'is_active'     => 1,
    ]);
        return redirect()->back()->with('success', 'Wallet updated successfully!');
    }
    public function shopwallet_update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'type'            => 'required|in:Credit,Debit',
            'amount'          => 'required|numeric|min:1',
            'remark'          => 'required|string',
            'old_cash_wallet' => 'required|numeric|min:0',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $user = User::findOrFail($id);
        $wallet = IncomeWallet::where('user_id', $user->user_id)->first();
        // If user has no wallet, create one
        if (!$wallet) {
            $wallet              = new IncomeWallet();
            $wallet->user_id     = $user->user_id;
            $wallet->shopping_wallet = 0;
        }
        $oldCashWallet = $request->old_cash_wallet;
        $amount        = $request->amount;
        $type          = $request->type;
        if ($wallet->shopping_wallet != $oldCashWallet) {
            return back()->with('error', 'Wallet balance has changed, please try again!');
        }
        // Handle Credit and Debit operations
        if ($type == 'Credit') {
            $wallet->shopping_wallet += $amount;
        } elseif ($type == 'Debit') {
            // Ensure debit does not exceed balance
            if ($wallet->shopping_wallet < $amount) {
                return back()->with('error', 'Insufficient balance in shopping_wallet !');
            }
            $wallet->shopping_wallet -= $amount;
        }
        $wallet->save();
        EditWallet::create([
            'user_id' => $user->user_id,
            'type'    => $type,
            'wallet'  => 'shopping_wallet ',
            'amount'  => $amount,
            'remark'  => $request->remark,
        ]);
    shopWalletIncome::create([
        'user_id'       => $user->user_id,
        'membership_id' => null, 
        'amount'        => $amount,
        'remark'        => $request->remark,
        'type'          => $type,
        'description'   => 'Manual ' . $type . ' by admin',
        'is_active'     => 1,
    ]);
        return redirect()->back()->with('success', 'Wallet updated successfully!');
    }
    public function create_plan(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title'               => 'required|string|max:255',
            'amount'              => 'required|numeric|min:1',
            'welcome_bonus'       => 'required|numeric|min:1',
            'daily_reward'        => 'required|numeric|min:1',
            'referral_percentage' => 'required|numeric|min:0|max:100',
            'cover_image'         => 'required'
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->with('error', $validator->errors()->first()) 
                ->withInput(); 
        }
        do {
            $membershipId = 'MEMZ' . rand(1000, 9999); 
        } while (Membership::where('membership_id', $membershipId)->exists());
        $imagepath = null;
            if ($request->hasFile('cover_image')) {
                $payment_image     = $request->file('cover_image');
                $payment_imagename = time() . '_' . $payment_image->getClientOriginalName();
                $payment_image->move(public_path('assets/images/cover_images'), $payment_imagename);
                $imagepath = 'assets/images/cover_images/' . $payment_imagename;
            }
        Membership::create([
            'membership_id'       => $membershipId,
            'title'               => $request->title,
            'amount'              => $request->amount,
            'welcome_bonus'       => $request->welcome_bonus,
            'daily_reward'        => $request->daily_reward,
            'referral_percentage' => $request->referral_percentage,
            'is_active'           => 1,
            'remark'              => 'plan_added',
            'image'               => $imagepath,
        ]);
        return redirect()->route('create_plan_form')->with('success', 'Membership created successfully!');
    }
    public function plan_delete(Request $request)
    {
        $membership = Membership::findOrFail($request->membership_id);
        $membership->delete();
        return redirect()->route('create_plan_history')->with('success', 'Membership plan deleted successfully.');
    }
    public function update_plan(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title'               => 'required|string|max:255',
            'amount'              => 'required|numeric',
            'welcome_bonus'       => 'required|numeric',
            'daily_reward'        => 'required|numeric',
            'referral_percentage' => 'required|numeric|min:0|max:100',
            'cover_image'         => 'nullable',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $membership = Membership::find($id);
        if (!$membership) {
            return redirect()->back()->with('error', 'Membership plan not found.');
        }
      // Handle image upload
    if ($request->hasFile('cover_image')) {
        // Delete old image if exists
        if (!empty($membership->image) && file_exists(public_path($membership->image))) {
            unlink(public_path($membership->image));
        }
        $image = $request->file('cover_image');
        $imageName = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('assets/images/cover_images'), $imageName);
        $imagePath = 'assets/images/cover_images/' . $imageName;
        // Update image path in the membership
        $membership->image = $imagePath;
    }
        $membership->update([
            'title'               => $request->title,
            'amount'              => $request->amount,
            'welcome_bonus'       => $request->welcome_bonus,
            'daily_reward'        => $request->daily_reward,
            'referral_percentage' => $request->referral_percentage,
            'image'               => $membership->image, 
        ]);
        return redirect()->route('create_plan_history')->with('success', 'Membership updated successfully!');
    }
    public function subscription_history()
{
    $datatables = UserSubscription::orderBy('id', 'desc')
    ->where('status','Accepted')
    ->get();
       return view('admin.subscription_history', compact('datatables'));
}
public function reject_subscription()
{
    $datatables = UserSubscription::orderBy('id', 'desc')
    ->where('status','Rejected')
    ->get();
       return view('admin.reject_subscription', compact('datatables'));
}
}
