<?php

namespace App\Http\Controllers\Video;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Video;
use App\Models\Branch;
use App\Models\Employee;
use App\Models\ContactUs;
use App\Models\Logo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\UserVideo;
use App\Models\IncomeWallet;
use App\Models\User;
use App\Models\shopWalletIncome;
use App\Models\Membership;

class VideoController extends Controller
{

    public function add_video()
    {
        $datatables = Video::orderby('id', 'desc')->get();
        return view('admin.add_video', compact('datatables'));
    }


    public function video_delete(Request $request)
    {
        $video = Video::findOrFail($request->delete_id);
        if ($video) {
            $video->delete();
            return redirect()->route('daily_task_history')->with('success', 'Notification deleted successfully.');
        }
        return redirect()->back()->with('error', 'Error not found');
    }


    public function daily_task()
    {
        try {
            $today = date('Y-m-d');

            $videocount = Video::whereDate('date', $today)->count();

            $videotask = Video::whereDate('date', $today)->orderBy('id', 'desc')->first();

            $uservideo = UserVideo::whereDate('created_at', $today)
                ->where('user_id', Auth::user()->user_id)
                ->count();

            return response()->json([
                'status' => 'success',
                'message' => 'Daily Task',
                'data' => [
                    'date' => $today,
                    "task" => $videotask ? $videotask->task : null,
                    "video_count" => $videocount,
                    "watched_count" => $uservideo,
                ],
                'code' => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage(),
                'code' => 500,
            ], 500);
        }
    }

    public function daily_videos()
    {
        $today = date('Y-m-d');
        $videos = Video::whereDate('date', $today)->get();
        $watchedVideoIds = UserVideo::whereDate('created_at', $today)
            ->where('user_id', Auth::user()->user_id)
            ->pluck('video_id')
            ->toArray();

        $videos = $videos->map(function ($video) use ($watchedVideoIds) {
            $video->is_watched = in_array($video->video_id, $watchedVideoIds) ? 1 : 0;
            return $video;
        });

        $membership = Membership::where('membership_id', Auth::user()->membership)->first();


        if ($videos->isNotEmpty()) {
            return response()->json([
                'status' => 'success',
                'message' => 'Daily Task',
                'date' => $today,
                'data' => $videos,
                'subscription_details' => $membership,
                'code' => 200,
            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'No data found!',
                'data' => [],
                'code' => 404,
            ], 404);
        }
    }

    // public function contact_update(Request $request)
    // {
    //     try {
    //         ContactUs::where('id', $request->id)->update([
    //             'phone_number'    => $request->phone_number,
    //             'wtsapp_number'   => $request->wtsapp_number,
    //             'email'           => $request->email,
    //             'company_address' => $request->company_address
    //         ]);
    //         return back()->with('success', 'Contact updated successfully!');
    //     } catch (\Exception $e) {
    //         // Log error if you want: \Log::error($e);
    //         return back()->with('error', 'Failed to update contact. Please try again.');
    //     }
    // }
    public function contact_update(Request $request)
{
    try {
       
        $userRole = Auth::user()->role ?? 'unknown';

 
        ContactUs::where('id', $request->id)->update([
            'phone_number'    => $request->phone_number,
            'wtsapp_number'   => $request->wtsapp_number,
            'email'           => $request->email,
            'company_address' => $request->company_address,
            'branch'          => $userRole,
        ]);

        return back()->with('success', 'Contact updated successfully!');
    } catch (\Exception $e) {
        return back()->with('error', 'Failed to update contact. Please try again.');
    }
}


    public function contact_delete(Request $request)
    {
        try {
            $contact = ContactUs::findOrFail($request->id);
            $contact->delete();
            return back()->with('success', 'Contact deleted successfully!');
        } catch (\Exception $e) {
            return back()->with('error', 'Failed to delete contact. Please try again.');
        }
    }

    // public function contact_toggle_status(Request $request)
    // {
    //     try {
    //         $contact = ContactUs::findOrFail($request->id);
    //         $contact->is_active = !$contact->is_active;
    //         $contact->save();
    //         return back()->with('success', 'Contact status successfully!');
    //     } catch (\Exception $e) {
    //         return back()->with('error', 'Failed to delete contact. Please try again.');
    //     }
    // }


    public function contact_toggle_status(Request $request)
{
    try {
        $contact = ContactUs::findOrFail($request->id);
        $contact->is_active = !$contact->is_active;
        $contact->save();

      return back()->with('success', 'Contact status successfully!');
    } catch (\Exception $e) {
       return back()->with('error', 'Failed to delete contact. Please try again.');
    }
}

    public function single_video($video_id = "")
    {
        try {
            $videos = Video::where('video_id', $video_id)->first();
            $membership = Membership::where('membership_id', Auth::user()->membership)->first();

            return response()->json([
                'status' => 'success',
                'message' => 'Daily Task',
                'data' => $videos,
                'subscription_details' => $membership,
                'code' => 200,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',
                'error' => $e->getMessage(),
                'code' => 500,
            ], 500);
        }
    }


    public function video_form(Request $request)
    {
        try {
            Log::info('Request fields:', [
                'video_id' => $request->video_id,
                'is_completed' => $request->is_completed
            ]);

            $validator = Validator::make($request->all(), [
                'video_id' => 'required|exists:videos,video_id',
                'is_completed' => 'required|boolean',
            ]);

            if ($validator->fails()) {
                Log::info('Validation errors:', $validator->errors()->toArray());

                return response()->json([
                    'status' => 'error',
                    'message' => 'Validation errors',
                    'code' => 422,
                    'data' => $validator->errors()
                ], 422);
            }

            Log::info('Validation Passed');

            $watchedVideo = UserVideo::where('video_id', $request->video_id)
                ->where('user_id', Auth::user()->user_id)
                ->first();

            if ($watchedVideo) {
                Log::info('Duplicate video entry found for user', [
                    'user_id' => Auth::user()->user_id,
                    'video_id' => $request->video_id
                ]);

                return response()->json([
                    'status' => 'error',
                    'message' => 'Duplicate entry',
                    'code' => 422,
                    'data' => 'Video Already Added'
                ], 422);
            }

            Log::info('Video not watched before, proceeding to save.');

            $userId = Auth::user()->user_id;
            $data = new UserVideo();
            $data->user_id = $userId;
            $data->video_id = $request->video_id;
            $data->save();

            Log::info('Video saved successfully', [
                'user_id' => $userId,
                'video_id' => $request->video_id
            ]);

            if ($request->is_completed == 1) {
                $today = date('Y-m-d');

                Log::info('Marking videos as completed', [
                    'user_id' => $userId,
                    'date' => $today
                ]);

                UserVideo::where('user_id', $userId)
                    ->whereDate('created_at', $today)
                    ->update(['is_completed' => 1]);

                Log::info('Updated completion status in the database');

                $this->video_income($userId);

                Log::info('Video income function executed');
            }
            $membership = Membership::where('membership_id', Auth::user()->membership)->first();

            return response()->json([
                'status' => 'success',
                'message' => 'Video status updated successfully',
                'data' => $data,
                'subscription_details' => $membership,
                'code' => 200,
            ], 200);
        } catch (\Exception $e) {
            Log::error('Exception Error in video_form:', [
                'error' => $e->getMessage()
            ]);

            return response()->json([
                'status' => 'error',
                'message' => 'Exception Error',
                'code' => 500,
                'data' => 'Something went wrong! Please try again.'
            ], 500);
        }
    }

    public function video_income($user_id)
    {
        try {
            Log::info("video_income started", ['user_id' => $user_id]);

            $user = User::where('user_id', $user_id)->first();
            if (!$user) {
                Log::info("User not found", ['user_id' => $user_id]);
                return false;
            }
            Log::info("User found", ['user_id' => $user_id]);

            Log::info("User found", ['user_id' => $user_id]);

            $membership = Membership::where('membership_id', $user->membership)->first();
            if (!$membership) {
                Log::info("Membership not found", ['membership_id' => $user->membership]);
                return false;
            }
            Log::info("Membership found", ['membership_id' => $membership->membership_id, 'daily_reward' => $membership->daily_reward]);


            $data = new shopWalletIncome();
            $data->user_id = $user_id;
            $data->membership_id = $membership->membership_id;
            $data->amount = $membership->daily_reward;
            $data->remark = "Video Income";
            $data->type = "credit";
            $data->save();

            Log::info("Video income saved", ['user_id' => $user_id, 'amount' => $membership->daily_reward]);

            $income_wallet = IncomeWallet::where('user_id', $user_id)->first();

            if ($income_wallet) {
                $income_wallet->video_income += $membership->daily_reward;
                $income_wallet->shopping_wallet += $membership->daily_reward;
                $income_wallet->save();
                Log::info("Updated income wallet", ['user_id' => $user_id, 'new_video_income' => $income_wallet->video_income, 'new_shopping_wallet' => $income_wallet->shopping_wallet]);
            } else {
                $newWallet = new IncomeWallet();
                $newWallet->user_id = $user_id;
                $newWallet->video_income = $membership->daily_reward;
                $newWallet->shopping_wallet = $membership->daily_reward;
                $newWallet->save();
                Log::info("Created new income wallet", ['user_id' => $user_id, 'video_income' => $newWallet->video_income, 'shopping_wallet' => $newWallet->shopping_wallet]);
            }

            return true;
        } catch (\Exception $e) {
            Log::error("Exception in video_income", [
                'user_id' => $user_id,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
            return false;
        }
    }


    public function add_video_form(Request $request)
    {
        try {
            Log::info('Video form submission started.', ['request_data' => $request->all()]);

            $validator = Validator::make($request->all(), [
                'note' => 'required',
                'task' => 'required',
                'video_link' => 'required|url',
                // 'cover_image' => 'required',
                'time' => ['required', 'regex:/^[0-5]?[0-9]:[0-5][0-9]$/'],
                'date' => 'required',
                'product_id' => 'nullable',
                'telegram_link' => 'nullable|url',
                'youtube_link' => 'nullable|url',
                'facebook_link' => 'nullable|url',
                'instagram_link' => 'nullable|url',

            ]);

            if ($validator->fails()) {
                Log::error('Validation failed.', ['errors' => $validator->errors()->all()]);
                return redirect()->back()->with('error', $validator->errors()->first());
            }

            do {
                $videoId = 'VDO' . rand(1000, 9999);
                $exists = DB::table('videos')->where('video_id', $videoId)->exists();
            } while ($exists);

            Log::info('Generated unique video_id.', ['video_id' => $videoId]);

            $imagepath = null;
            if ($request->hasFile('cover_image')) {
                $payment_image = $request->file('cover_image');
                $payment_imagename = time() . '_' . $payment_image->getClientOriginalName();
                $payment_image->move(public_path('assets/images/cover_images'), $payment_imagename);
                $imagepath = 'assets/images/cover_images/' . $payment_imagename;
            }

            // Save to Database
            $video = new Video();
            $video->video_id = $videoId;
            $video->date = $request->date;
            $video->note = $request->note;
            $video->task = $request->task;
            $video->video_link = $request->video_link;
            $video->time = $request->time;
            $video->cover_image = $imagepath;
            $video->product_id = $request->product_id;
            $video->telegram_link = $request->telegram_link;
            $video->youtube_link = $request->youtube_link;
            $video->facebook_link = $request->facebook_link;
            $video->instagram_link = $request->instagram_link;
            $video->save();

            Log::info('Video saved successfully.', ['video_id' => $videoId]);

            return redirect()->route('add_video')->with('success', 'Video added successfully.');
        } catch (\Exception $e) {
            Log::error('Exception occurred while adding video.', ['error' => $e->getMessage()]);
            return redirect()->route('add_video')->with('error', "Exception Error: " . $e->getMessage());
        }
    }
    public function update_dailytask(Request $request, $id)
    {
        $request->validate([
            'date' => 'required|date',
            'task' => 'required|string|max:255',
            'note' => 'nullable|string|max:255',
            'video_link' => 'nullable|string',
            'time' => 'nullable|string',
            'cover_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'telegram_link' => 'nullable|url',
            'youtube_link' => 'nullable|url',
            'facebook_link' => 'nullable|url',
            'instagram_link' => 'nullable|url',
        ]);

        $video = Video::findOrFail($id);
        $video->date = $request->date;
        $video->task = $request->task;
        $video->note = $request->note;
        $video->video_link = $request->video_link;
        $video->time = $request->time;
        $video->telegram_link = $request->telegram_link;
        $video->youtube_link = $request->youtube_link;
        $video->facebook_link = $request->facebook_link;
        $video->instagram_link = $request->instagram_link;

        if ($request->hasFile('cover_image')) {
            if ($video->cover_image && file_exists(public_path('uploads/videos/' . $video->cover_image))) {
                unlink(public_path('uploads/videos/' . $video->cover_image));
            }

            $imagepath = null;
            if ($request->hasFile('cover_image')) {
                $payment_image = $request->file('cover_image');
                $payment_imagename = time() . '_' . $payment_image->getClientOriginalName();
                $payment_image->move(public_path('assets/images/cover_images'), $payment_imagename);
                $imagepath = 'assets/images/cover_images/' . $payment_imagename;
            }

            $video->cover_image = $imagepath;
        }

        $video->save();

        return redirect()->back()->with('success', 'Video updated successfully.');


    }
    public function show_daily_task()
    {
        try {
            $videos = Video::all();

            if ($videos->isEmpty()) {
                return response()->json([
                    'status' => 'success',
                    'message' => 'No videos found.',
                    'data' => [],
                    'code' => 200,
                ], 200);
            }

            return response()->json([
                'status' => 'success',
                'message' => 'Videos fetched successfully.',
                'data' => $videos->map(function ($video) {
                    return [
                        'video_id' => $video->video_id,
                        'note' => $video->note,
                        'video_link' => $video->video_link,
                        'task' => $video->task,
                        'time' => $video->time,
                        'date' => $video->date,
                        'cover_image' => url($video->cover_image),
                        'is_active' => (bool) $video->is_active,
                    ];
                }),
                'code' => 200,
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Failed to fetch videos.',
                'error' => $e->getMessage(),
                'code' => 500,
            ], 500);
        }
    }
public function contact_submit(Request $request)
{
    Log::info('Contact submit request received.', $request->all());

    $validator = Validator::make($request->all(), [
        'phone_number'     => 'required|max:10',
        'wtsapp_number'    => 'required|max:10',
        'email'            => 'required|email|max:255',
        'company_address'  => 'required',
    ]);

    if ($validator->fails()) {
        Log::warning('Validation failed for contact submit.', [
            'errors' => $validator->errors()->toArray()
        ]);

        return redirect()->back()
            ->withErrors($validator)
            ->withInput();
    }

    $userRole = Auth::user()->role ?? 'unknown';
    Log::info('Authenticated user role:', ['role' => $userRole]);

    try {
        Log::info('Deactivating existing contact records...');
        ContactUs::query()->update(['is_active' => 0]);

        Log::info('Creating new contact record...');
        ContactUs::create([
            'phone_number'    => $request->phone_number,
            'wtsapp_number'   => $request->wtsapp_number,
            'email'           => $request->email,
            'company_address' => $request->company_address,
            'is_active'       => 1,
            'branch'          => $userRole,
        ]);

        Log::info('Contact info submitted successfully.');
        return redirect()->back()->with('success', 'Contact info submitted successfully.');
    } catch (\Exception $e) {
        Log::error('Error while submitting contact info.', [
            'error' => $e->getMessage(),
            'trace' => $e->getTraceAsString()
        ]);

        return redirect()->back()->with('error', 'Something went wrong. Please try again.');
    }
}

public function add_logo_post(Request $request)
{
    try {
        $user = Auth::user();

        $validator = Validator::make($request->all(), [
            'image' => 'required|image|max:2048',
            'branch_id' => $user->role === 'admin' ? 'required|exists:branches,id' : 'nullable'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        if ($user->role === 'admin') {
            $branch = Branch::find($request->branch_id);
            if (!$branch) {
                return redirect()->back()->with('error', 'Invalid branch selected.');
            }
        } else {
            $roleToBranchName = [
                'sakthi'           => 'Sakthi Super Mart',
                'smart_world'      => 'SMARTWORLD',
                'smart_world_gift' => 'SMARTWORLD - Stationary & Gifts',
                'yoga_naturals'    => 'Yogaa Naturals',
            ];

            $branchName = $roleToBranchName[$user->role] ?? null;

            if (!$branchName) {
                return redirect()->back()->with('error', 'Invalid role or branch not mapped.');
            }

            $branch = Branch::where('branch_name', $branchName)->first();

            if (!$branch) {
                return redirect()->back()->with('error', 'Branch not found for your role.');
            }
        }

        $imagePath = null;
        if ($request->hasFile('image')) {
            $file = $request->file('image');
            if (!$file->isValid()) {
                return redirect()->back()->with('error', 'File upload failed.');
            }
            $fileName = time() . '_' . $file->getClientOriginalName();
            $destinationPath = public_path('assets/images/banners');
            $file->move($destinationPath, $fileName);
            $imagePath = 'assets/images/banners/' . $fileName;
        }

        $logo = new Logo();
        $logo->image     = $imagePath;
        $logo->is_active = '1';
        $logo->branch    = $branch->branch_name; 
        $logo->save();

        return redirect()->back()->with('success', 'Logo added successfully.');

    } catch (\Exception $e) {
        Log::error('Error adding logo: ' . $e->getMessage());
        return redirect()->back()->with('error', 'Something went wrong. Please try again.');
    }
}

//     public function add_logo_post(Request $request)
//     {
//         $validator = Validator::make($request->all(), [

//             'image' => 'required|image|max:2048',
//         ]);
//         if ($validator->fails()) {
//             return redirect()->back()->withErrors($validator)->withInput();
//         }
//   $userRole = Auth::user()->role ?? 'unknown';
//     Log::info('Authenticated user role:', ['role' => $userRole]);
//         $imagePath = null;
//         if ($request->hasFile('image')) {
//             $file = $request->file('image');
//             if (!$file->isValid()) {
//                 return redirect()->back()->with('error', 'File upload failed.');
//             }
//             $fileName = time() . '_' . $file->getClientOriginalName();
//             $destinationPath = public_path('assets/images/banners');
//             $file->move($destinationPath, $fileName);
//             $imagePath = 'assets/images/banners/' . $fileName;
//         }

//         $banner            = new Logo();
//         $banner->image     = $imagePath;
//         $banner->is_active = '1';
//         $banner->branch    = $userRole;
//         $banner->save();
//         return redirect()->back()->with('success', 'language added successfully.');
//     }

}

