<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
     public function toArray(Request $request): array
    {
        return [
            'id'               => $this->id,
            'product_id'       => $this->product_id,
            'category_id'      => $this->category_id,
            'subcategory_id'   => $this->subcategory_id,
            'product_images'   => $this->getProductImages(),
            'product_video'    => $this->product_video ? url($this->product_video) : null,
            'brand'            => $this->brand,
            'title'            => $this->title,
            'description'      => $this->description,
            'stock'            => $this->stock,
            'youtube_url'      => $this->youtube_url,
            'unit'             => $this->unit,
            'mrp'              => $this->mrp,
            'sell_price'       => $this->sell_price,
            'gst'              => $this->gst,
            'discount'         => $this->discount,
            'shop_wallet'      => $this->shop_wallet,
            'payble_amount'    => $this->payble_amount,
            'gst_price'        => $this->gst_price,
            'is_active'        => $this->is_active,
            'is_wishlist'      => $this->is_wishlist,
            'category_name'    => $this->category_name,
            'subcategory_name' => $this->subcategory_name,
            // Include the variants relationship data
            'variants'         => $this->variants,
        ];
    }

    private function getProductImages()
    {
        $images = json_decode($this->product_image, true); 
    
        if (is_array($images)) {
            return array_map(function ($image) {
                return url($image); 
            }, $images);
        }
    
        return [];
    }
    
}

