<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubCategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
           
            'category_id'      => $this->cat_id,
            'subcategory_id'   => $this->subcategory_id,
            'category_name'    => $this->category ? $this->category->category_name : null,
            'subcategory_name' => $this->subcategory ? $this->subcategory->subcategory_name : null,
            'category_img'     => $this->category_img,
        ];
    }
}
