<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\URL;

class UserDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        
        $membership = $this->membership; 

        return [
            'id'                    => $this->id,
            'user_id'               => $this->user_id, 
            'name'                  => $this->name,
            'email'                 => $this->email,
            'phone_number'          => $this->phone_number,
            'profile_image'         => $this->profile_image ? url($this->profile_image) : null, 
            'is_subscribed'         => $this->is_subscribed,
            'subscribed_at'         => $this->subscribed_at,
            'subscription_end_date' => $this->subscription_end_date,
            'joining_date'          => $this->created_at,
            'referral_id'           => $this->referral_id,
            'membership_title'      => $membership ? $membership->title : null, 
            'referral_link'         => $this->generateReferralLink(),
        ];
    }
    private function generateReferralLink(): string
    {
        $domain = URL::to('/');
        return $domain . '/register/' . base64_encode($this->user_id);
    }
}