<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WishlistResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'user_id'       => $this->user_id,
            'product_id'    => $this->product_id,
            'product_name'  => $this->product_name,
            'product_image' => $this->getFirstProductImage(),
            'mrp'           => $this->product->mrp ?? null,
            'sell_price'    => $this->product->sell_price ?? null,
            'discount'      => $this->product->discount ?? null,
            'shop_wallet'   => $this->product->shop_wallet,
            'payble_amount' => $this->product->payble_amount ?? null,
            'stock'         => $this->product->stock ?? null,
            'category_name' => $this->product->category_name ?? null,
            'brand'         => $this->product->brand ?? null,
            'unit'          => $this->product->unit ?? null,
            'created_at'    => $this->created_at,
            'updated_at'    => $this->updated_at,
           
        ];
    }

    private function getFirstProductImage()
    {
        if ($this->product && $this->product->product_image) { 
            $images = json_decode($this->product->product_image, true);
            if (is_array($images) && !empty($images)) {
                return url($images[0]); 
            }
        }
        return null;
    }
   
}

