<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Address extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'userid',
        'name',
        'house_no',
        'road_name',
        'landmark',
        'district',
        'state',
        'pin',
        'is_current',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function getCurrentAddress($userId)
    {
        return self::where('user_id', $userId)
                   ->where('is_current', true)
                   ->first();
    }


}
