<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
     protected $fillable = [
        'bill_number',
        'user_id',
        'userid',
        'customer_name',
        'customer_phone',
        'sub_total',
        'tax_amount',
        'discount_amount',
        'additional_charge',
        'total_amount',
        'received_amount',
        'change_amount',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(BillItem::class);
    }
}
