<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BillItem extends Model
{
     protected $fillable = [
        'bill_id',
        'product_id',
        'product_variant_id',
        'item_name',
        'item_code',
        'mrp',
        'sell_price',
        'quantity',
        'gst_percentage',
        'cgst_percentage',
        'sgst_percentage',
        'item_discount_amount',
        'total_amount',
    ];

    public function bill()
    {
        return $this->belongsTo(Bill::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function productVariant()
    {
        return $this->belongsTo(ProductVarient::class, 'product_variant_id'); // Corrected relationship name
    }
}
