<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $fillable = [
        'cat_id',
        'category_name',
        'subcategory_name',
        'link_to',
        'category_img',
        'category_type',
    ];

    public function deliveryFeeMaster()
    {
        return $this->belongsTo(DeliveryFeeMaster::class, 'town_id');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id');
    }

    public function subcategories()
    {
        return $this->hasMany(Category::class, 'link_to');
    }

    public function parentCategory()
    {
        return $this->belongsTo(Category::class, 'link_to');
    }
}

