<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MyPurchase extends Model
{
    protected $fillable = [
        'product_purchase_id',
        'invoice_number',
        'purchase_date',
        'discount_amount',
        'discount_note',
        'additional_charge',
        'additional_charge_note',
        'gst_total',
        'sub_total_excluding_gst',
        'sub_total_including_gst',
        'total_amount',
        'branch',
        'print_type',
    ];

    public function purchaseParty()
    {
        return $this->belongsTo(ProductPurchase::class, 'product_purchase_id');
    }

    public function items()
    {
        return $this->hasMany(MyPurchaseItem::class, 'my_purchase_id');
    }



}
