<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MyPurchaseItem extends Model
{
    protected $fillable = [
        'my_purchase_id',
        'product_id',
        'quantity',
        'purchase_price',
        'sell_price',
        'gst_percentage',
        'cgst',
        'sgst',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function purchase()
    {
        return $this->belongsTo(MyPurchase::class, 'my_purchase_id');
    }
}
