<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MySalesItem extends Model
{
   protected $fillable = [
        'invoice_id',
        'product_id',
        'quantity',
        'purchase_price',
        'sell_price',
        'gst_percentage',
        'cgst',
        'sgst',
    ];

    public function purchase()
    {
        return $this->belongsTo(MyPurchase::class, 'product_purchase_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
