<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;
class OfflineSale extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'order_id',
        'sale_items',
        'total_amount',
        'cash_wallet_deduction',
        'shopping_wallet_deduction',
        'discount',
        'description',
        'amount_payable',
        'customer_details',
        'status',
        'additional_charge',
        'payment_mode',
        'payment_received',
        'change_amount',
        'admin_role',
        'total_tax',
        'tax_value',
        'cgst',
        'sgst',
        'branch',
        'sub_total'
    ];
    protected $casts = [
    'customer_details'          => 'array',
    'sale_items'                => 'array',
    'created_at'                => 'datetime',
    'updated_at'                => 'datetime',
    'total_tax'                 => 'decimal:2',
    'tax_value'                 => 'decimal:2',
    'cash_wallet_deduction'     => 'decimal:2',
    'shopping_wallet_deduction' => 'decimal:2',
    ];
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }
}