<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $fillable=
    [
        'user_id',
        'status',
        'subtotal',
        'delivery_fee',
        'total_amount',
    
    ];
    public function products()
    {
        return $this->belongsToMany(Product::class);

    }
    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function orderDetails()
{
    return $this->hasOne(OrderDetails::class);
}




}
