<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderDetails extends Model
{
    use HasFactory;
    protected $fillable = [
        'order_date',
        'user_id',
        'user_name',
        'category_id',
        'category_name',
        'subcategory_id',
        'subcategory_name',
        'order_random_id',
        'product_details_id',
        'imei_serial_numbers',
        'image',
        'variant_id',
        'hsn_code',
        'product_details_name',
        'price_details',
        'quantity',
        'amount',
        'delivery_address',
        'status',
        'shopp_wallet',
        'cash_wallet',
        'gst_price',
        'gst_percent',
        'instruction',
        'is_shipped',
        'shiprocket_order_id',
        'shipment_id',
        'delivery_fee',
        'ship_rocket_status',
        'house_no',
        'road_name',
        'landmark',
        'district',
        'state',
        'pin',
        'razorpay_payment_id',
        'razorpay_order_id'
    ];



    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }


    public function product()
    {
        return $this->belongsTo(Product::class, 'product_details_id', 'id');
    }
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_random_id', 'order_random_id');
    }


}
