<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'category_id',
        'subcategory_id',
        'product_image',
        'product_video',
        'brand',
        'item_code',
        'hsn_code',
        'title',
        'description',
        'stock',
        'youtube_url',
        'unit',
        'mrp',
        'sell_price',
        'gst',
        'cgst',
        'sgst',
        'discount',
        'shop_wallet',
        'payble_amount',
        'gst_price',
        'is_active',
        'is_note',
        'category_name',
        'subcategory_name',
        'branch_id',
        'branch_name',
        'barcode1',
        'barcode2',
        'purchase_price',
        'user_role'
    ];
    public function variants()
    {
        return $this->hasMany(ProductVarient::class, 'product_id', 'product_id');
    }
    public function orders()
    {
        return $this->hasMany(Order::class, 'product_id');
    }
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
    public function subcategory()
    {
        return $this->belongsTo(Category::class, 'subcategory_id');
    }
    public function wishlist()
    {
        return $this->hasMany(Wishlist::class, 'product_id', 'id');
    }
}
