<?php
namespace App\Models;
// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
class User extends Authenticatable
{
    use HasFactory, Notifiable, HasApiTokens;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'user_id',
        'referral_id',
        'referral_name',
        'email',
        'password',
        'password_hint',
        'phone_number',
        'is_active',
        'role',
        'is_subscribed',
        'membership',
        'house_no',
        'building_name',
        'road_name',
        'landmark',
        'district',
        'state',
        'pin',
        'forgot_token',
        'profile_image',
        'otp',
        'otp_expires_at',
        'is_verfied',
        'subscribed_at',
        'subscription_end_date',
        'is_gst',
        'is_note',
        'gst_number',
        'logo',
    ];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];
    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'password' => 'hashed',
        ];
    }
    public function incomeWallet()
    {
        return $this->hasOne(IncomeWallet::class, 'user_id', 'user_id');
    }
    public function orderDetails()
    {
        return $this->hasMany(OrderDetails::class, 'user_id', 'user_id');
    }
    public function addresses()
    {
        return $this->hasMany(Address::class);
    }
    public function currentAddress()
    {
        return $this->hasOne(Address::class)->where('is_current', 1);
    }
    public function membershipRelation()
    {
        return $this->belongsTo(Membership::class, 'membership', 'membership_id');
    }
public function branch()
{
    return $this->belongsTo(Branch::class, 'branch_id');
}
}
