<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WithdrawRequest extends Model
{
    protected $fillable = [
        'user_id',
        'amount',
        'bank_id',
        'status',
        'is_active',
        'type',
        'gpay_number'
    ];

    public function user()
{
    return $this->belongsTo(User::class, 'user_id', 'user_id');
}

public function bankDetails()
{
    return $this->belongsTo(BankDetails::class, 'bank_id', 'id');
}

}
