<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class shopWalletIncome extends Model
{
    protected $fillable = [
        'user_id',
        'membership_id',
        'amount',
        'remark',
        'type',
        'description',
        'payment_mode',
        'is_active'
    ];
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }
    public function userSubscription()
{
    return $this->belongsTo(UserSubscription::class, 'membership_id', 'membership_id');
}


public function offlineSale()
{
    return $this->hasOne(OfflineSale::class, 'order_id', 'order_id');
}


}
