<?php

namespace App\Traits;


use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use ZipArchive;
use Exception;

trait BackUpTrait
{

    public function backupProject()
    {
        try {
            Log::info("Project Backup started Sterz");

            $date        = Carbon::now()->format('Y-m-d_H-i-s');
            $projectPath = base_path();
            $folder      = 'backups';
            $filename    = "project_backup_latest.zip";
            $backupPath  = storage_path("app/{$folder}/{$filename}");

            Storage::makeDirectory($folder);

            if (file_exists($backupPath)) {
                unlink($backupPath);
            }

            $zip = new ZipArchive;
            if ($zip->open($backupPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
                $files = new \RecursiveIteratorIterator(
                    new \RecursiveDirectoryIterator($projectPath),
                    \RecursiveIteratorIterator::LEAVES_ONLY
                );

                foreach ($files as $name => $file) {
                    if (!$file->isDir()) {
                        $filePath     = $file->getRealPath();
                        $relativePath = substr($filePath, strlen($projectPath) + 1);

                        if ($relativePath === "{$folder}/{$filename}") {
                            continue;
                        }

                        $zip->addFile($filePath, $relativePath);
                    }
                }

                $zip->close();
            } else {
                throw new \Exception("Unable to create zip file.");
            }



            return ['status' => true, 'message' => "✅ Project backup created and emailed."];
        } catch (\Exception $e) {
            Log::error("❌ Project Backup Failed: " . $e->getMessage());
            return ['status' => false, 'message' => "Backup failed: " . $e->getMessage()];
        }
    }

    public function backupDatabase()
    {
        try {

            Log::info("DB Backup started Sterz");

            $date     = Carbon::now()->format('Y-m-d_H-i-s');
            $db       = env('DB_DATABASE');
            $user     = env('DB_USERNAME');
            $pass     = env('DB_PASSWORD');
            $host     = env('DB_HOST');
            $filename = storage_path("app/backups/db_backup_latest.sql");

            Storage::makeDirectory('backups');

            $files = Storage::files('backups');
            foreach ($files as $file) {
                if (str_ends_with($file, '.sql')) {
                    Storage::delete($file);
                }
            }

            $command = "mysqldump -h {$host} -u {$user} -p\"{$pass}\" {$db} > {$filename}";
            exec($command);


            return ['status' => true, 'message' => "Database backup completed and sent."];
        } catch (Exception $e) {
            Log::error("Database Backup Failed: " . $e->getMessage());
            return ['status' => false, 'message' => "Backup failed: " . $e->getMessage()];
        }
    }
}