<?php

namespace App;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

trait ShiprocketTrait
{
    public function shiprocket_get_token()
    {
        try {
            $response = Http::post('https://apiv2.shiprocket.in/v1/external/auth/login', [
                'email'    => 'sterbin001@gmail.com',
                'password' => 'Sterbin#021',
            ]);

            $jsonData = $response->json();

            if (isset($jsonData['token'])) {
                Log::info("Shiprocket Token Generated Successfully");
                return $jsonData['token'];
            } else {
                Log::info("Failed to get Shiprocket token", $jsonData);
                return null;
            }
        } catch (\Throwable $th) {
            Log::info("Shiprocket Token Error: " . $th->getMessage());
            return null;
        }
    }

    public function api($method, $urls, $data = null)
    {
        try {
            $url = "https://apiv2.shiprocket.in/v1/external/" . $urls;

            $token = $this->shiprocket_get_token();

            if (!$token) {
                Log::info("Token retrieval failed. Cannot make API request.");
                return (object)[
                    'message' => 'Token error',
                    'error' => 'Failed to retrieve token'
                ];
            }

            $headers = [
                'Content-Type'  => 'application/json',
                'Authorization' => 'Bearer ' . $token
            ];

            Log::info("Shiprocket API Request", [
                'method' => strtoupper($method),
                'url' => $url,
                'payload' => $data
            ]);

            $response = strtolower($method) === "post"
                ? Http::withHeaders($headers)->post($url, $data)
                : Http::withHeaders($headers)->get($url, $data);

            Log::info("Shiprocket API Response", [
                'status' => $response->status(),
                'body' => $response->json()
            ]);

            if ($response->successful()) {
                return $response->object();
            } else {
                Log::info("API request failed", [
                    'status' => $response->status(),
                    'error' => $response->json()
                ]);
                return (object)[
                    'message' => 'Request failed',
                    'error' => $response->json()
                ];
            }
        } catch (\Throwable $th) {
            Log::info("Shiprocket API Error", [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString()
            ]);
            return (object)[
                'message' => 'Exception occurred',
                'error' => $th->getMessage()
            ];
        }
    }
}
