<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('product_id')->nullable();
            $table->string('category_id')->nullable();
            $table->string('subcategory_id')->nullable();
            $table->text('product_image');
            $table->text('product_video')->nullable();
            $table->string('category_name')->nullable();
            $table->string('subcategory_name')->nullable();
            $table->string('brand')->nullable();
            $table->string('item_code')->nullable();
            $table->string('hsn_code')->nullable();
            $table->string('title');
            $table->text('description')->nullable();
            $table->integer('stock');
            $table->string('youtube_url')->nullable();
            $table->string('unit')->nullable();
            $table->decimal('mrp', 10, 2);
            $table->decimal('sell_price', 10, 2);
            $table->decimal('cgst', 10, 2)->nullable();
            $table->decimal('sgst', 10, 2)->nullable();
            $table->decimal('purchase_price', 10, 2)->nullable();
            $table->decimal('gst', 5, 2);
            $table->decimal('discount', 5, 2);
            $table->decimal('shop_wallet', 10, 2);
            $table->decimal('payble_amount', 10, 2)->nullable();
            $table->decimal('gst_price', 10, 2);
            $table->boolean('is_active')->default(1);
            $table->boolean('is_note')->default(0);
            $table->string('branch_id')->nullable();
            $table->string('branch_name')->nullable();
            $table->string('barcode1')->nullable();
            $table->string('barcode2')->nullable();
                $table->string('user_role')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
