<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('order_details', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('user_name');
            $table->string('category_id')->nullable();
            $table->string('subcategory_id')->nullable();
            $table->timestamp('order_date')->nullable();
            $table->string('category_name')->nullable();
            $table->string('subcategory_name')->nullable();
            $table->string('product_details_id');
            $table->text('imei_serial_numbers')->nullable();
            $table->string('variant_id')->nullable();
            $table->string('order_random_id')->nullable();
            $table->string('product_details_name');
            $table->text('image')->nullable();
            $table->text('delivery_address');
            $table->text('price_details')->nullable();
            $table->text('instruction')->nullable();
            $table->text('hsn_code')->nullable();
            $table->string('status')->default('pending');
            $table->text('quantity');
            $table->text('gst_percent')->nullable();
            $table->decimal('shopp_wallet', 10, 2)->nullable();
            $table->decimal('cash_wallet', 10, 2)->nullable();
            $table->decimal('gst_price', 10, 2)->nullable();
            $table->decimal('amount', 10, 2);
            $table->decimal('delivery_fee', 10, 2);
            $table->string('one')->nullable();
            $table->string('two')->nullable();
            $table->string('three')->nullable();
             $table->string('razorpay_payment_id')->nullable();
            $table->string('razorpay_order_id')->nullable();
            $table->boolean('is_shipped')->default(0);
            $table->string('shiprocket_order_id')->nullable();
            $table->string('shipment_id')->nullable();
            $table->enum('ship_rocket_status', ['Placed', 'Shipped', 'Picked', 'Cancelled', 'Delivered'])->default('new');
            $table->string('house_no')->nullable();
            $table->string('road_name')->nullable();
            $table->string('landmark')->nullable();
            $table->string('district')->nullable();
            $table->string('state')->nullable();
            $table->string('pin')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_details');
    }
};









