<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('offline_sales', function (Blueprint $table) {
      $table->id();
      $table->string('user_id');
      $table->string('order_id');
      $table->text('sale_items');
      $table->text('customer_details');
      $table->text('status');
      $table->decimal('total_amount', 10, 2);
      $table->decimal('cash_wallet_deduction', 10, 2)->default(0.00);
      $table->decimal('shopping_wallet_deduction', 10, 2)->default(0.00);
      $table->decimal('discount', 10, 2)->default(0.00);
      $table->decimal('amount_payable', 10, 2);
      $table->decimal('additional_charge', 10, 2)->default(0.00);
      $table->decimal('payment_received', 10, 2)->default(0.00);
      $table->decimal('change_amount', 10, 2)->default(0.00);
      $table->text('payment_mode')->nullable();
      $table->text('description')->nullable();
      $table->text('admin_role')->nullable();
      $table->decimal('total_tax', 10, 2)->nullable();
      $table->decimal('tax_value', 10, 2)->nullable();
      $table->decimal('cgst', 10, 2)->nullable();
      $table->decimal('sgst', 10, 2)->nullable();
      $table->text('branch')->nullable();
      $table->decimal('sub_total', 10, 2)->nullable();
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('offline_stores');
  }
};
