<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('memberships', function (Blueprint $table) {
            $table->id();
            $table->string('membership_id');
            $table->string('image')->nullable();
            $table->string('title');
            $table->float('amount', 15, 2)->default(0);
            $table->float('daily_reward', 15, 2)->default(0);
            $table->float('referral_percentage', 15, 2)->default(0);
            $table->float('welcome_bonus', 15, 2)->default(0);
            $table->integer('days')->nullable();
            $table->string('benefit1')->nullable();
            $table->string('benefit2')->nullable();
            $table->string('benefit3')->nullable();
            $table->string('benefit4')->nullable();
            $table->boolean('is_active')->default(1);
            $table->text('remark')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('memberships');
    }
};
